/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.validator.clazz;

import cn.allbs.hj212.exception.T212FormatException;
import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public abstract class FieldValidator<A extends Annotation, V, AF extends Annotation, FV>
implements ConstraintValidator<A, V> {
    protected String field;
    private AF af;
    private ConstraintValidator<AF, FV> constraintValidator;

    public FieldValidator(ConstraintValidator<AF, FV> constraintValidator) {
        this.constraintValidator = constraintValidator;
    }

    public void initialize(A a) {
        this.field = this.getField(a);
        this.af = this.getAnnotation(a);
        this.constraintValidator.initialize(this.af);
    }

    public boolean isValid(V value, ConstraintValidatorContext constraintValidatorContext) {
        FV fv = this.getFieldValue(value, this.field);
        boolean result = this.constraintValidator.isValid(fv, constraintValidatorContext);
        if (!result) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(this.getFieldMessage(this.af)).addPropertyNode(this.field).addConstraintViolation();
        }
        return result;
    }

    public abstract String getField(A var1);

    public abstract AF getAnnotation(A var1);

    public abstract FV getFieldValue(V var1, String var2);

    public abstract String getFieldMessage(AF var1);

    public static void create_format_exception(Set<? extends ConstraintViolation> constraintViolationSet, Object result) throws T212FormatException {
        Map<String, String> typePropertys = constraintViolationSet.stream().collect(Collectors.groupingBy(ConstraintViolation::getMessage, new Collector<ConstraintViolation, StringJoiner, String>(){

            @Override
            public Supplier<StringJoiner> supplier() {
                return () -> new StringJoiner(",", "", "");
            }

            @Override
            public BiConsumer<StringJoiner, ConstraintViolation> accumulator() {
                return (s, cv) -> s.add("'" + cv.getPropertyPath() + "'");
            }

            @Override
            public BinaryOperator<StringJoiner> combiner() {
                return StringJoiner::merge;
            }

            @Override
            public Function<StringJoiner, String> finisher() {
                return StringJoiner::toString;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.emptySet();
            }
        }));
        String msg = typePropertys.entrySet().stream().map(kv -> "\t" + (String)kv.getKey() + " -> " + (String)kv.getValue()).collect(Collectors.joining("\n"));
        throw new T212FormatException("Validate error\n" + msg).withResult(result);
    }

    public static void create_format_exception2(Set<? extends ConstraintViolation> constraintViolationSet) throws T212FormatException {
        Map typeCVs = constraintViolationSet.stream().collect(Collectors.groupingBy(ConstraintViolation::getMessage, Collectors.toList()));
        Map<String, String> typePropertys = typeCVs.entrySet().stream().map(kv -> {
            String pps = ((List)kv.getValue()).stream().map(cv -> "'" + cv.getPropertyPath() + "'").collect(Collectors.joining(","));
            return new AbstractMap.SimpleEntry(kv.getKey(), pps);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        String msg = typePropertys.entrySet().stream().map(kv -> "\t" + (String)kv.getKey() + " -> " + (String)kv.getValue()).collect(Collectors.joining("\n"));
        throw new T212FormatException("Validate error\n" + msg);
    }
}

