/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.format;

import cn.allbs.hj212.config.T212Configurator;
import cn.allbs.hj212.deser.CpDataLevelMapDeserializer;
import cn.allbs.hj212.deser.DataDeserializer;
import cn.allbs.hj212.deser.DataLevelMapDeserializer;
import cn.allbs.hj212.deser.PackLevelDeserializer;
import cn.allbs.hj212.deser.T212Deserializer;
import cn.allbs.hj212.exception.T212FormatException;
import cn.allbs.hj212.feature.Feature;
import cn.allbs.hj212.feature.ParserFeature;
import cn.allbs.hj212.feature.SegmentParserFeature;
import cn.allbs.hj212.feature.VerifyFeature;
import cn.allbs.hj212.format.T212Factory;
import cn.allbs.hj212.format.T212Generator;
import cn.allbs.hj212.format.T212Parser;
import cn.allbs.hj212.model.HjData;
import cn.allbs.hj212.ser.CpDataLevelMapDataSerializer;
import cn.allbs.hj212.ser.DataSerializer;
import cn.allbs.hj212.ser.PackLevelSerializer;
import cn.allbs.hj212.ser.T212Serializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Validator;

public class T212Mapper {
    private static T212Factory t212FactoryProtoType;
    private int verifyFeatures;
    private int parserFeatures;
    private T212Factory factory = t212FactoryProtoType.copy();
    private T212Configurator configurator = new T212Configurator();
    private Validator validator = this.factory.validator();
    private ObjectMapper objectMapper = this.factory.objectMapper();
    private static final int SEGMENT_FEATURE_BIT_OFFSET = 8;

    public T212Mapper enableDefaultParserFeatures() {
        this.parserFeatures = Feature.collectFeatureDefaults(SegmentParserFeature.class);
        this.parserFeatures <<= 8;
        this.parserFeatures |= Feature.collectFeatureDefaults(ParserFeature.class);
        return this;
    }

    public T212Mapper enableDefaultVerifyFeatures() {
        this.verifyFeatures |= Feature.collectFeatureDefaults(VerifyFeature.class);
        return this;
    }

    public T212Mapper enable(SegmentParserFeature feature) {
        this.parserFeatures |= feature.getMask() << 8;
        return this;
    }

    public T212Mapper enable(ParserFeature feature) {
        this.parserFeatures |= feature.getMask();
        return this;
    }

    public T212Mapper enable(VerifyFeature feature) {
        this.verifyFeatures |= feature.getMask();
        return this;
    }

    public T212Mapper disable(SegmentParserFeature feature) {
        this.parserFeatures &= ~(feature.getMask() << 8);
        return this;
    }

    public T212Mapper disable(ParserFeature feature) {
        this.parserFeatures &= ~feature.getMask();
        return this;
    }

    public T212Mapper disable(VerifyFeature feature) {
        this.verifyFeatures &= ~feature.getMask();
        return this;
    }

    public T212Mapper configurator(T212Configurator configurator) {
        this.configurator = configurator;
        return this;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    private T212Mapper applyConfigurator() {
        this.configurator.setSegmentParserFeature(this.parserFeatures >> 8);
        this.configurator.setParserFeature(this.parserFeatures & 0xFF);
        this.configurator.setVerifyFeature(this.verifyFeatures);
        this.configurator.setValidator(this.validator);
        this.configurator.setObjectMapper(this.objectMapper);
        this.factory.setConfigurator(this.configurator);
        return this;
    }

    public <T> T readValue(InputStream is, Class<T> value) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(is), value);
    }

    public <T> T readValue(byte[] bytes, Class<T> value) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(bytes), value);
    }

    public <T> T readValue(Reader reader, Class<T> value) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(reader), value);
    }

    public <T> T readValue(String data, Class<T> value) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(data), value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T _readValueAndClose(T212Parser parser, Class<T> value) throws IOException, T212FormatException {
        T212Deserializer<T> deserializer = this.factory.deserializerFor(value);
        try (T212Parser p = parser;){
            T t = deserializer.deserialize(p);
            return t;
        }
        catch (RuntimeException e) {
            throw new T212FormatException("Runtime error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T _readValueAndClose(T212Parser parser, Type type, Class<T> value) throws IOException, T212FormatException {
        T212Deserializer<T> deserializer = this.factory.deserializerFor(type, value);
        try (T212Parser p = parser;){
            T t = deserializer.deserialize(p);
            return t;
        }
        catch (RuntimeException e) {
            throw new T212FormatException("Runtime error", e);
        }
    }

    public <T> void writeValueAsStream(T value, Class<T> type, OutputStream outputStream) throws IOException, T212FormatException {
        this.applyConfigurator();
        this._writeValueAndClose(this.factory.generator(outputStream), value, type);
    }

    public <T> void writeValueAsWriter(T value, Class<T> type, Writer writer) throws IOException, T212FormatException {
        this.applyConfigurator();
        this._writeValueAndClose(this.factory.generator(writer), value, type);
    }

    private <T> void _writeValueAndClose(T212Generator generator, T value, Class<T> type) throws IOException, T212FormatException {
        T212Serializer<T> serializer = this.factory.serializerFor(type);
        try (T212Generator g = generator;){
            serializer.serialize(g, value);
        }
        catch (RuntimeException e) {
            throw new T212FormatException("Runtime error", e);
        }
    }

    private static Supplier<Type> getMapGenericType() {
        return () -> new Map<String, String>(){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean containsKey(Object key) {
                return false;
            }

            @Override
            public boolean containsValue(Object value) {
                return false;
            }

            @Override
            public String get(Object key) {
                return null;
            }

            @Override
            public String put(String key, String value) {
                return null;
            }

            @Override
            public String remove(Object key) {
                return null;
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> m) {
            }

            @Override
            public void clear() {
            }

            @Override
            public Set<String> keySet() {
                return null;
            }

            @Override
            public Collection<String> values() {
                return null;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return null;
            }
        }.getClass().getGenericInterfaces()[0];
    }

    private static Supplier<Type> getDeepMapGenericType() {
        return () -> new Map<String, Object>(){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean containsKey(Object key) {
                return false;
            }

            @Override
            public boolean containsValue(Object value) {
                return false;
            }

            @Override
            public String get(Object key) {
                return null;
            }

            @Override
            public String put(String key, Object value) {
                return null;
            }

            @Override
            public String remove(Object key) {
                return null;
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> m) {
            }

            @Override
            public void clear() {
            }

            @Override
            public Set<String> keySet() {
                return null;
            }

            @Override
            public Collection<Object> values() {
                return null;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return null;
            }
        }.getClass().getGenericInterfaces()[0];
    }

    public Map<String, String> readMap(InputStream is) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(is), T212Mapper.getMapGenericType().get(), Map.class);
    }

    public Map<String, String> readMap(byte[] bytes) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(bytes), T212Mapper.getMapGenericType().get(), Map.class);
    }

    public Map<String, String> readMap(Reader reader) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(reader), T212Mapper.getMapGenericType().get(), Map.class);
    }

    public Map<String, String> readMap(String data) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(data), T212Mapper.getMapGenericType().get(), Map.class);
    }

    public Map<String, Object> readDeepMap(InputStream is) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(is), T212Mapper.getDeepMapGenericType().get(), Map.class);
    }

    public Map<String, Object> readDeepMap(byte[] bytes) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(bytes), T212Mapper.getDeepMapGenericType().get(), Map.class);
    }

    public Map<String, Object> readDeepMap(Reader reader) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(reader), T212Mapper.getDeepMapGenericType().get(), Map.class);
    }

    public Map<String, Object> readDeepMap(String data) throws IOException, T212FormatException {
        this.applyConfigurator();
        return this._readValueAndClose(this.factory.parser(data), T212Mapper.getDeepMapGenericType().get(), Map.class);
    }

    public HjData readData(InputStream is) throws IOException, T212FormatException {
        return this.readValue(is, HjData.class);
    }

    public HjData readData(byte[] bytes) throws IOException, T212FormatException {
        return this.readValue(bytes, HjData.class);
    }

    public HjData readData(Reader reader) throws IOException, T212FormatException {
        return this.readValue(reader, HjData.class);
    }

    public HjData readData(String data) throws IOException, T212FormatException {
        return this.readValue(data, HjData.class);
    }

    public String writeMapAsString(Map data) throws IOException, T212FormatException {
        StringWriter sw = new StringWriter();
        this.writeValueAsWriter(data, Map.class, sw);
        return sw.toString();
    }

    public char[] writeMapAsCharArray(Map data) throws IOException, T212FormatException {
        return this.writeMapAsString(data).toCharArray();
    }

    public String writeDataAsString(HjData data) throws IOException, T212FormatException {
        StringWriter sw = new StringWriter();
        this.writeValueAsWriter(data, HjData.class, sw);
        return sw.toString();
    }

    public char[] writeDataAsCharArray(HjData data) throws IOException, T212FormatException {
        return this.writeDataAsString(data).toCharArray();
    }

    static {
        try {
            t212FactoryProtoType = new T212Factory();
            t212FactoryProtoType.deserializerRegister(CpDataLevelMapDeserializer.class);
            t212FactoryProtoType.deserializerRegister(DataLevelMapDeserializer.class);
            t212FactoryProtoType.deserializerRegister(PackLevelDeserializer.class);
            t212FactoryProtoType.deserializerRegister((Type)((Object)Map.class), (Class<? extends T212Deserializer>)CpDataLevelMapDeserializer.class);
            t212FactoryProtoType.deserializerRegister((Type)((Object)HjData.class), (Class<? extends T212Deserializer>)DataDeserializer.class);
            t212FactoryProtoType.deserializerRegister((Type)((Object)Object.class), (Class<? extends T212Deserializer>)CpDataLevelMapDeserializer.class);
            t212FactoryProtoType.serializerRegister(PackLevelSerializer.class);
            t212FactoryProtoType.serializerRegister((Type)((Object)HjData.class), (Class<? extends T212Serializer>)DataSerializer.class);
            t212FactoryProtoType.serializerRegister((Type)((Object)Map.class), (Class<? extends T212Serializer>)CpDataLevelMapDataSerializer.class);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }
}

