/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.deser;

import cn.allbs.hj212.config.SegmentParser;
import cn.allbs.hj212.core.Configurator;
import cn.allbs.hj212.core.Configured;
import cn.allbs.hj212.deser.SegmentDeserializer;
import cn.allbs.hj212.deser.T212Deserializer;
import cn.allbs.hj212.enums.HjDataFlag;
import cn.allbs.hj212.exception.SegmentFormatException;
import cn.allbs.hj212.exception.T212FormatException;
import cn.allbs.hj212.feature.VerifyFeature;
import cn.allbs.hj212.format.T212Parser;
import cn.allbs.hj212.format.VerifyUtil;
import cn.allbs.hj212.model.verify.DataElement;
import cn.allbs.hj212.model.verify.PacketElement;
import cn.allbs.hj212.model.verify.T212DataLevelMap;
import cn.allbs.hj212.model.verify.T212Map;
import cn.allbs.hj212.model.verify.groups.ModeGroup;
import cn.allbs.hj212.model.verify.groups.VersionGroup;
import cn.allbs.hj212.validator.clazz.FieldValidator;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.groups.Default;

public class DataLevelMapDeserializer
implements T212Deserializer<Map<String, String>>,
Configured<DataLevelMapDeserializer> {
    private int verifyFeature;
    private Configurator<SegmentParser> segmentParserConfigurator;
    private SegmentDeserializer<Map<String, String>> segmentDeserializer;
    private Validator validator;

    @Override
    public void configured(Configurator<DataLevelMapDeserializer> configurator) {
        configurator.config(this);
    }

    @Override
    public Map<String, String> deserialize(T212Parser parser) throws IOException, T212FormatException {
        parser.readHeader();
        int len = parser.readInt32(10);
        if (len == -1) {
            T212FormatException.length_not_range(PacketElement.DATA_LEN, len, 4, 4);
        }
        if (VerifyFeature.DATA_LEN_RANGE.enabledIn(this.verifyFeature)) {
            VerifyUtil.verifyRange(len, 0, 1024, PacketElement.DATA_LEN);
        }
        char[] data = parser.readData(len);
        int crc = parser.readInt32(16);
        if (VerifyFeature.DATA_CRC.enabledIn(this.verifyFeature) && (crc == -1 || T212Parser.crc16Checkout(data, len) != crc)) {
            T212FormatException.crc_verification_failed(PacketElement.DATA, data, crc);
        }
        return this.deserialize(data);
    }

    public Map<String, String> deserialize(char[] data) throws IOException, T212FormatException {
        PushbackReader reader = new PushbackReader(new CharArrayReader(data));
        SegmentParser parser = new SegmentParser(reader);
        parser.configured(this.segmentParserConfigurator);
        Map<String, String> result = null;
        try {
            result = this.segmentDeserializer.deserialize(parser);
        }
        catch (SegmentFormatException e) {
            T212FormatException.segment_exception(e);
        }
        if (VerifyFeature.USE_VERIFICATION.enabledIn(this.verifyFeature)) {
            this.verifyByType(result);
        }
        return result;
    }

    private void verifyByType(Map<String, String> result) throws T212FormatException {
        Set constraintViolationSet;
        T212DataLevelMap t212Map = T212Map.createDataLevel(result);
        ArrayList<Class> groups = new ArrayList<Class>();
        groups.add(Default.class);
        int flag = 0;
        if (result.containsKey(DataElement.Flag.name())) {
            String f = result.get(DataElement.Flag.name());
            flag = Integer.valueOf(f);
        }
        if (HjDataFlag.V0.isMarked(flag)) {
            groups.add(VersionGroup.V2017.class);
        } else {
            groups.add(VersionGroup.V2005.class);
        }
        if (HjDataFlag.D.isMarked(flag)) {
            groups.add(ModeGroup.UseSubPacket.class);
        }
        if (!(constraintViolationSet = this.validator.validate((Object)t212Map, groups.toArray(new Class[0]))).isEmpty() && VerifyFeature.THROW_ERROR_VERIFICATION_FAILED.enabledIn(this.verifyFeature)) {
            FieldValidator.create_format_exception(constraintViolationSet, result);
        }
    }

    public void setVerifyFeature(int verifyFeature) {
        this.verifyFeature = verifyFeature;
    }

    public void setSegmentParserConfigurator(Configurator<SegmentParser> segmentParserConfigurator) {
        this.segmentParserConfigurator = segmentParserConfigurator;
    }

    public void setSegmentDeserializer(SegmentDeserializer<Map<String, String>> segmentDeserializer) {
        this.segmentDeserializer = segmentDeserializer;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

