/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.converter;

import cn.allbs.hj212.converter.Converter;
import cn.allbs.hj212.core.Configurator;
import cn.allbs.hj212.core.Configured;
import cn.allbs.hj212.enums.HjDataFlag;
import cn.allbs.hj212.model.CpData;
import cn.allbs.hj212.model.Device;
import cn.allbs.hj212.model.HjData;
import cn.allbs.hj212.model.LiveSide;
import cn.allbs.hj212.model.Pollution;
import cn.allbs.hj212.model.verify.T212Map;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataReverseConverter
implements Converter<HjData, T212Map<String, Object>>,
Configured<DataReverseConverter> {
    private ObjectMapper objectMapper;

    private Map<String, Map<String, String>> convertLiveSide(Map<String, LiveSide> map) {
        if (map == null) {
            return null;
        }
        return map.entrySet().stream().map(kv -> {
            Map value = (Map)this.objectMapper.convertValue(kv.getValue(), Map.class);
            return new AbstractMap.SimpleEntry(kv.getKey(), value);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private Map<String, Map<String, String>> convertDevice(Map<String, Device> map) {
        if (map == null) {
            return null;
        }
        return map.entrySet().stream().map(kv -> {
            String key = "SB" + (String)kv.getKey();
            Map value = (Map)this.objectMapper.convertValue(kv.getValue(), Map.class);
            return new AbstractMap.SimpleEntry<String, Map>(key, value);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private Map<String, Map<String, String>> convertPollution(Map<String, Pollution> map) {
        if (map == null) {
            return null;
        }
        return map.entrySet().stream().map(kv -> {
            Map value = (Map)this.objectMapper.convertValue(kv.getValue(), Map.class);
            return new AbstractMap.SimpleEntry(kv.getKey(), value);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    private T212Map<String, Object> convertDataLevel(CpData cp) {
        Map map = (Map)this.objectMapper.convertValue((Object)cp, Map.class);
        if (cp.getDataFlag() != null && !cp.getDataFlag().isEmpty()) {
            String flag = this.convertDataFlag(cp.getDataFlag());
            map.put(HjData.FLAG, flag);
        }
        if (cp.getDevice() != null && !cp.getDevice().isEmpty()) {
            map.remove(CpData.DEVICE);
            Map<String, Map<String, String>> device = this.convertDevice(cp.getDevice());
            map.putAll(device);
        }
        if (cp.getLiveSide() != null && !cp.getLiveSide().isEmpty()) {
            map.remove(CpData.LIVESIDE);
            Map<String, Map<String, String>> liveSide = this.convertLiveSide(cp.getLiveSide());
            map.putAll(liveSide);
        }
        if (cp.getPollution() != null && !cp.getPollution().isEmpty()) {
            map.remove(CpData.POLLUTION);
            Map<String, Map<String, String>> pollution = this.convertPollution(cp.getPollution());
            map.putAll(pollution);
        }
        return T212Map.createCpDataLevel(map);
    }

    private String convertDataFlag(List<HjDataFlag> flag) {
        int i = 0;
        if (flag == null) {
            return "";
        }
        for (HjDataFlag dataFlag : flag) {
            i = dataFlag.getBit() & i;
        }
        return Integer.toString(i);
    }

    private T212Map<String, Object> convertDataLevel(HjData data) {
        Map map = (Map)this.objectMapper.convertValue((Object)data, Map.class);
        if (data.getDataFlag() != null && !data.getDataFlag().isEmpty()) {
            map.remove(HjData.FLAG);
            String flag = this.convertDataFlag(data.getDataFlag());
            map.put(HjData.FLAG, flag);
        }
        if (data.getCp() != null) {
            T212Map<String, Object> cpMap = this.convertDataLevel(data.getCp());
            map.put(HjData.CP, cpMap);
        }
        return T212Map.createCpDataLevel(map);
    }

    @Override
    public T212Map<String, Object> convert(HjData data) {
        return this.convertDataLevel(data);
    }

    @Override
    public void configured(Configurator<DataReverseConverter> by) {
        by.config(this);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

