/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.ser;

import cn.allbs.hj212.config.SegmentGenerator;
import cn.allbs.hj212.exception.SegmentFormatException;
import cn.allbs.hj212.ser.SegmentSerializer;
import java.io.IOException;
import java.util.Map;

public class MapValueSegmentSerializer
implements SegmentSerializer<Object> {
    protected final SegmentSerializer<Map<String, Object>> _valueSerializer;
    protected final Object2MapConverter _object2MapConverter;

    public MapValueSegmentSerializer(SegmentSerializer<Map<String, Object>> _valueSerializer, Object2MapConverter _object2MapConverter) {
        this._valueSerializer = _valueSerializer;
        this._object2MapConverter = _object2MapConverter;
    }

    @Override
    public void serialize(SegmentGenerator generator, Object data) throws IOException, SegmentFormatException {
        if (data instanceof String) {
            String value = (String)data;
            generator.writeValue(value);
        } else {
            SegmentGenerator g = generator.writeObjectStart();
            Map<String, Object> map = this._object2MapConverter.convert(data);
            this._valueSerializer.serialize(g, map);
            generator.writeObjectEnd();
        }
    }

    public static interface Object2MapConverter {
        public Map<String, Object> convert(Object var1) throws SegmentFormatException;
    }
}

