/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.deser;

import cn.allbs.hj212.config.SegmentParser;
import cn.allbs.hj212.converter.DataConverter;
import cn.allbs.hj212.core.Configurator;
import cn.allbs.hj212.core.Configured;
import cn.allbs.hj212.deser.SegmentDeserializer;
import cn.allbs.hj212.deser.T212Deserializer;
import cn.allbs.hj212.enums.HjDataFlag;
import cn.allbs.hj212.exception.SegmentFormatException;
import cn.allbs.hj212.exception.T212FormatException;
import cn.allbs.hj212.feature.VerifyFeature;
import cn.allbs.hj212.format.T212Parser;
import cn.allbs.hj212.format.VerifyUtil;
import cn.allbs.hj212.model.HjData;
import cn.allbs.hj212.model.verify.PacketElement;
import cn.allbs.hj212.model.verify.T212Map;
import cn.allbs.hj212.model.verify.groups.ModeGroup;
import cn.allbs.hj212.model.verify.groups.VersionGroup;
import cn.allbs.hj212.validator.clazz.FieldValidator;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.groups.Default;

public class DataDeserializer
implements T212Deserializer<HjData>,
Configured<DataDeserializer> {
    private int verifyFeature;
    private Configurator<SegmentParser> segmentParserConfigurator;
    private SegmentDeserializer<Map<String, Object>> segmentDeserializer;
    private Configurator<DataConverter> dataConverterConfigurator;
    private Validator validator;

    @Override
    public void configured(Configurator<DataDeserializer> configurator) {
        configurator.config(this);
    }

    @Override
    public HjData deserialize(T212Parser parser) throws IOException, T212FormatException {
        parser.readHeader();
        int len = parser.readInt32(10);
        if (len == -1) {
            T212FormatException.length_not_range(PacketElement.DATA_LEN, len, 4, 4);
        }
        if (VerifyFeature.DATA_LEN_RANGE.enabledIn(this.verifyFeature)) {
            VerifyUtil.verifyRange(len, 0, 1024, PacketElement.DATA_LEN);
        }
        char[] data = parser.readData(len);
        int crc = parser.readInt32(16);
        if (VerifyFeature.DATA_CRC.enabledIn(this.verifyFeature) && (crc == -1 || T212Parser.crc16Checkout(data, len) != crc)) {
            T212FormatException.crc_verification_failed(PacketElement.DATA, data, crc);
        }
        return this.deserialize(data);
    }

    public HjData deserialize(char[] data) throws IOException, T212FormatException {
        PushbackReader reader = new PushbackReader(new CharArrayReader(data));
        SegmentParser parser = new SegmentParser(reader);
        parser.configured(this.segmentParserConfigurator);
        Map<String, Object> result = null;
        try {
            result = this.segmentDeserializer.deserialize(parser);
        }
        catch (SegmentFormatException e) {
            T212FormatException.segment_exception(e);
        }
        return this.deserialize(result);
    }

    public HjData deserialize(Map<String, Object> map) throws T212FormatException {
        DataConverter dataConverter = new DataConverter();
        dataConverter.configured(this.dataConverterConfigurator);
        HjData result = dataConverter.convert(T212Map.createCpDataLevel(map));
        if (VerifyFeature.USE_VERIFICATION.enabledIn(this.verifyFeature)) {
            this.verify(result);
        }
        return result;
    }

    private void verify(HjData result) throws T212FormatException {
        Set constraintViolationSet;
        ArrayList<Class> groups = new ArrayList<Class>();
        groups.add(Default.class);
        if (HjDataFlag.V0.isMarked(result.getDataFlag())) {
            groups.add(VersionGroup.V2017.class);
        } else {
            groups.add(VersionGroup.V2005.class);
        }
        if (HjDataFlag.D.isMarked(result.getDataFlag())) {
            groups.add(ModeGroup.UseSubPacket.class);
        }
        if (!(constraintViolationSet = this.validator.validate((Object)result, groups.toArray(new Class[0]))).isEmpty() && VerifyFeature.THROW_ERROR_VERIFICATION_FAILED.enabledIn(this.verifyFeature)) {
            FieldValidator.create_format_exception(constraintViolationSet, result);
        }
    }

    public void setVerifyFeature(int verifyFeature) {
        this.verifyFeature = verifyFeature;
    }

    public void setSegmentParserConfigurator(Configurator<SegmentParser> segmentParserConfigurator) {
        this.segmentParserConfigurator = segmentParserConfigurator;
    }

    public void setSegmentDeserializer(SegmentDeserializer<Map<String, Object>> segmentDeserializer) {
        this.segmentDeserializer = segmentDeserializer;
    }

    public void setDataConverterConfigurator(Configurator<DataConverter> mapperConfigurator) {
        this.dataConverterConfigurator = mapperConfigurator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

