/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.core;

import cn.allbs.hj212.core.Configurator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class MultipleConfiguratorAdapter
implements Configurator {
    private Map<Type, Configurator> cacheConfigurators;
    private boolean useCache;

    protected MultipleConfiguratorAdapter() {
        this.cache(this.configurators());
    }

    public void cache(Collection<Configurator> collection) {
        this.useCache = !collection.isEmpty();
        this.cacheConfigurators = collection.stream().collect(Collectors.toMap(MultipleConfiguratorAdapter.getConfiguratorTargetType(), Function.identity()));
    }

    private void useCache(Object target) {
        this.cacheConfigurators.get(target.getClass()).config(target);
    }

    private void notCache(Object target) {
        this.configurators().stream().filter(configurator -> MultipleConfiguratorAdapter.checkConfiguratorTargetType(configurator, target)).findFirst().ifPresent(configurator -> configurator.config(target));
    }

    public abstract Collection<Configurator> configurators();

    public void config(Object target) {
        if (this.useCache) {
            this.useCache(target);
        } else {
            this.notCache(target);
        }
    }

    private static Function<Configurator, Type> getConfiguratorTargetType() {
        return configurator -> (Type)((Object)Stream.of(configurator.getClass().getGenericInterfaces()).filter(t -> t instanceof ParameterizedType).map(t -> (ParameterizedType)t).filter(pt -> pt.getRawType().equals(Configurator.class)).map(pt -> pt.getActualTypeArguments()[0]).findFirst().orElse((Type)((Object)Object.class)));
    }

    private static boolean checkConfiguratorTargetType(Configurator configurator, Object target) {
        return Stream.of(configurator.getClass().getGenericInterfaces()).filter(t -> t instanceof ParameterizedType).map(t -> (ParameterizedType)t).filter(pt -> pt.getRawType().equals(Configurator.class)).map(pt -> pt.getActualTypeArguments()[0]).anyMatch(t -> t.equals(target.getClass()));
    }
}

