/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.translator;

import cn.allbs.hj212.translator.CodeMatch;
import cn.allbs.hj212.translator.CodeMean;
import cn.allbs.hj212.translator.CodePattern;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.UnsupportedDataTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum H212Translator {
    I;

    private static final Logger log;
    private Map<Enum, Pattern> compilePattern = Collections.synchronizedMap(new LinkedHashMap());
    private Map<Class<? extends Enum>, Object> expandCode = Collections.synchronizedMap(new LinkedHashMap());

    public String translation(Class<? extends Enum> codeType, String code) throws UnsupportedDataTypeException, ClassNotFoundException {
        Object codeMeanMap;
        if (!this.expandCode.containsKey(codeType)) {
            this.register(codeType);
        }
        if ((codeMeanMap = this.expandCode.get(codeType)) instanceof Map) {
            Map map = (Map)codeMeanMap;
            return ((CodeMean)Optional.ofNullable(map.get(code)).orElseThrow(ClassNotFoundException::new)).mean();
        }
        if (codeMeanMap instanceof List) {
            Set set = (Set)codeMeanMap;
            return set.stream().filter(cm -> cm.match(code)).findAny().orElseThrow(ClassNotFoundException::new).mean();
        }
        return null;
    }

    public boolean register(Class<? extends Enum> codeType) throws UnsupportedDataTypeException {
        if (this.expandCode.containsKey(codeType)) {
            throw new UnsupportedOperationException("Repeat registration");
        }
        Optional<Class> selfCompiled = Stream.of(codeType.getInterfaces()).filter(i -> i.equals(CodeMatch.class)).findAny();
        if (selfCompiled.isPresent()) {
            Set map = Stream.of(codeType.getEnumConstants()).map(cm -> (CodeMatch)((Object)cm)).collect(Collectors.toCollection(() -> new TreeSet((o1, o2) -> {
                int i = o1.order() - o2.order();
                if (i == 0) {
                    ++i;
                }
                return i;
            })));
            this.expandCode.put(codeType, map);
            return true;
        }
        Optional<Class> needCompile = Stream.of(codeType.getInterfaces()).filter(i -> i.equals(CodePattern.class)).findAny();
        if (needCompile.isPresent()) {
            Set map = Stream.of(codeType.getEnumConstants()).map(cm -> (CodePattern)((Object)cm)).map(CodePatternMatchAdapter::adaptation).collect(Collectors.toCollection(() -> new TreeSet((o1, o2) -> {
                int i = o1.order() - o2.order();
                if (i == 0) {
                    ++i;
                }
                return i;
            })));
            this.expandCode.put(codeType, map);
            return true;
        }
        Stream.of(codeType.getInterfaces()).filter(i -> i.equals(CodeMean.class)).findAny().orElseThrow(UnsupportedDataTypeException::new);
        Map map = Stream.of(codeType.getEnumConstants()).map(cm -> (CodeMean)((Object)cm)).collect(Collectors.toMap(CodeMean::code, Function.identity(), (k1, k2) -> k2));
        this.expandCode.put(codeType, map);
        return true;
    }

    public boolean expand(Class<? extends Enum> codeType, String code, final String mean, final Predicate<String> predicate) throws UnsupportedDataTypeException, ClassNotFoundException {
        if (!this.expandCode.containsKey(codeType)) {
            this.register(codeType);
        }
        Object codeMeanMap = this.expandCode.get(codeType);
        final String finalCode = code;
        if (codeMeanMap instanceof Map) {
            Map map = (Map)codeMeanMap;
            CodeMean cm = new CodeMean(){

                @Override
                public String code() {
                    return finalCode;
                }

                @Override
                public String mean() {
                    return mean;
                }
            };
            map.put(code, cm);
        } else if (codeMeanMap instanceof List) {
            Set set = (Set)codeMeanMap;
            CodeMatch cm = new CodeMatch(){

                @Override
                public boolean match(String code) {
                    return predicate.test(code);
                }

                @Override
                public String pattern() {
                    return null;
                }

                @Override
                public int order() {
                    return -1;
                }

                @Override
                public String code() {
                    return finalCode;
                }

                @Override
                public String mean() {
                    return mean;
                }
            };
            set.add(cm);
        }
        return true;
    }

    static {
        log = LoggerFactory.getLogger(H212Translator.class);
    }

    private static class CodePatternMatchAdapter
    implements CodeMatch {
        private CodePattern codePattern;
        private Pattern pattern;

        private CodePatternMatchAdapter() {
        }

        public static CodePatternMatchAdapter adaptation(CodePattern codePattern) {
            CodePatternMatchAdapter adapter = new CodePatternMatchAdapter();
            adapter.codePattern = codePattern;
            adapter.pattern = Pattern.compile(codePattern.pattern());
            return adapter;
        }

        @Override
        public boolean match(String code) {
            return this.pattern.asPredicate().test(code);
        }

        @Override
        public String pattern() {
            return this.codePattern.pattern();
        }

        @Override
        public int order() {
            return -1;
        }

        @Override
        public String code() {
            return this.codePattern.code();
        }

        @Override
        public String mean() {
            return this.codePattern.mean();
        }
    }
}

