/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.ser;

import cn.allbs.hj212.core.Configurator;
import cn.allbs.hj212.core.Configured;
import cn.allbs.hj212.exception.T212FormatException;
import cn.allbs.hj212.feature.VerifyFeature;
import cn.allbs.hj212.format.T212Generator;
import cn.allbs.hj212.format.VerifyUtil;
import cn.allbs.hj212.model.Pack;
import cn.allbs.hj212.model.verify.PacketElement;
import cn.allbs.hj212.ser.T212Serializer;
import java.io.IOException;
import java.util.Arrays;

public class PackLevelSerializer
implements T212Serializer<Pack>,
Configured<PackLevelSerializer> {
    private Configurator<T212Generator> generatorConfigurator;
    private int verifyFeature;

    @Override
    public void configured(Configurator<PackLevelSerializer> configurator) {
        configurator.config(this);
    }

    @Override
    public void serialize(T212Generator generator, Pack pack) throws IOException, T212FormatException {
        generator.configured(this.generatorConfigurator);
        generator.writeHeader();
        if (VerifyFeature.DATA_LEN_RANGE.enabledIn(this.verifyFeature)) {
            int segmentLen = 0;
            if (!Arrays.equals(pack.getLength(), new char[]{'\u0000', '\u0000', '\u0000', '\u0000'})) {
                segmentLen = Integer.parseInt(new String(pack.getLength()));
            }
            if (segmentLen == 0) {
                segmentLen = pack.getSegment().length;
            }
            VerifyUtil.verifyRange(segmentLen, 0, 1024, PacketElement.DATA_LEN);
        }
        generator.writeDataAndLenAndCrc(pack.getSegment());
        if (VerifyFeature.DATA_CRC.enabledIn(this.verifyFeature) && !Arrays.equals(pack.getCrc(), new char[]{'\u0000', '\u0000', '\u0000', '\u0000'})) {
            VerifyUtil.verifyCrc(pack.getSegment(), pack.getCrc(), PacketElement.DATA_CRC);
        }
        generator.writeFooter();
    }

    public void setVerifyFeature(int verifyFeature) {
        this.verifyFeature = verifyFeature;
    }

    public void setGeneratorConfigurator(Configurator<T212Generator> generatorConfigurator) {
        this.generatorConfigurator = generatorConfigurator;
    }
}

