/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.deser;

import cn.allbs.hj212.config.SegmentParser;
import cn.allbs.hj212.config.SegmentToken;
import cn.allbs.hj212.deser.MapValueSegmentDeserializer;
import cn.allbs.hj212.deser.SegmentDeserializer;
import cn.allbs.hj212.deser.StringSegmentDeserializer;
import cn.allbs.hj212.exception.SegmentFormatException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapSegmentDeserializer
implements SegmentDeserializer<Map<String, Object>> {
    protected final SegmentDeserializer<?> _valueDeserializer;
    protected final SegmentDeserializer<String> _stringValueDeserializer;

    public MapSegmentDeserializer() {
        this._valueDeserializer = new MapValueSegmentDeserializer(this);
        this._stringValueDeserializer = new StringSegmentDeserializer();
    }

    public MapSegmentDeserializer(SegmentDeserializer<Object> valueDeserializer) {
        this._valueDeserializer = valueDeserializer;
        this._stringValueDeserializer = new StringSegmentDeserializer();
    }

    @Override
    public Map<String, Object> deserialize(SegmentParser parser) throws IOException, SegmentFormatException {
        if (parser.currentToken() == null) {
            parser.initToken();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.readMap(parser, result);
        return result;
    }

    private void readMap(SegmentParser parser, Map<String, Object> result) throws IOException, SegmentFormatException {
        String key = parser.readKey();
        while (key != null) {
            SegmentToken token = parser.currentToken();
            Object value = null;
            switch (token) {
                case NOT_AVAILABLE: {
                    return;
                }
                case END_PART_KEY: {
                    assert (false);
                }
                case END_SUB_ENTRY: 
                case END_ENTRY: 
                case END_OBJECT_VALUE: {
                    break;
                }
                case END_KEY: 
                case START_OBJECT_VALUE: {
                    value = this._valueDeserializer.deserialize(parser);
                }
            }
            result.put(key, value);
            key = parser.readKey();
        }
    }
}

