/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.excel.handle;

import cn.allbs.excel.annotation.ExcelLine;
import cn.allbs.excel.handle.ListAnalysisEventListener;
import cn.allbs.excel.kit.Validators;
import cn.allbs.excel.vo.ErrorMessage;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnalysisEventListener
extends ListAnalysisEventListener<Object> {
    private static final Logger log = LoggerFactory.getLogger(DefaultAnalysisEventListener.class);
    private final List<Object> list = new ArrayList<Object>();
    private final List<ErrorMessage> errorMessageList = new ArrayList<ErrorMessage>();
    private Long lineNum = 1L;

    public void invoke(Object o, AnalysisContext analysisContext) {
        Long l = this.lineNum;
        Long l2 = this.lineNum = Long.valueOf(this.lineNum + 1L);
        Set<ConstraintViolation<Object>> violations = Validators.validate(o);
        if (!violations.isEmpty()) {
            HashSet<String> errorSet = new HashSet<String>();
            violations.forEach(a -> {
                try {
                    Field field = o.getClass().getDeclaredField(a.getPropertyPath().toString());
                    String filedName = Optional.ofNullable(field.getAnnotation(ExcelProperty.class)).map(anno -> anno.value()[0]).orElse(field.getName());
                    errorSet.add(filedName + a.getMessage());
                }
                catch (Exception e) {
                    log.error("\u57df\u89e3\u6790\u9519\u8bef" + e.getLocalizedMessage());
                }
            });
            this.errorMessageList.add(new ErrorMessage(this.lineNum, errorSet));
        } else {
            Field[] fields;
            for (Field field : fields = o.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(ExcelLine.class) || field.getType() != Long.class) continue;
                try {
                    field.setAccessible(true);
                    field.set(o, this.lineNum);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            this.list.add(o);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        log.debug("Excel read analysed");
    }

    @Override
    public List<Object> getList() {
        return this.list;
    }

    @Override
    public List<ErrorMessage> getErrors() {
        return this.errorMessageList;
    }
}

