/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;

public enum TimestampStringConverter implements Converter<Timestamp>
{
    INSTANCE;


    public Class supportJavaTypeKey() {
        return Timestamp.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Timestamp convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws ParseException {
        return Timestamp.valueOf(cellData.getStringValue());
    }

    public WriteCellData<String> convertToExcelData(Timestamp value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String timeFormatter = "";
        if (null != value) {
            timeFormatter = value.toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return new WriteCellData(timeFormatter);
    }
}

