/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.excel.convert;

import cn.allbs.common.utils.StringUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public enum LocalDateStringConverter implements Converter<LocalDate>
{
    INSTANCE;


    public Class supportJavaTypeKey() {
        return LocalDate.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalDate convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws ParseException {
        if (contentProperty == null || contentProperty.getDateTimeFormatProperty() == null) {
            if (cellData.getStringValue().length() < "yyyy-MM-dd".length() && cellData.getStringValue().contains("-")) {
                String[] time = cellData.getStringValue().split("-");
                String sb = time[0] + "-" + StringUtil.padPre((CharSequence)time[1], (int)2, (CharSequence)"0") + "-" + StringUtil.padPre((CharSequence)time[2], (int)2, (CharSequence)"0");
                cellData.setStringValue(sb);
            }
            return LocalDate.parse(cellData.getStringValue());
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(contentProperty.getDateTimeFormatProperty().getFormat());
        return LocalDate.parse(cellData.getStringValue(), formatter);
    }

    public WriteCellData<String> convertToExcelData(LocalDate value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        DateTimeFormatter formatter = contentProperty == null || contentProperty.getDateTimeFormatProperty() == null ? DateTimeFormatter.ISO_LOCAL_DATE : DateTimeFormatter.ofPattern(contentProperty.getDateTimeFormatProperty().getFormat());
        return new WriteCellData(value.format(formatter));
    }
}

