/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.excel;

import cn.allbs.excel.ExcelHandlerConfiguration;
import cn.allbs.excel.aop.DynamicNameAspect;
import cn.allbs.excel.aop.ExportExcelReturnValueHandler;
import cn.allbs.excel.aop.ImportExcelArgumentResolver;
import cn.allbs.excel.config.ExcelConfigProperties;
import cn.allbs.excel.processor.NameProcessor;
import cn.allbs.excel.processor.NameSpelExpressionProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@AutoConfiguration
@Import(value={ExcelHandlerConfiguration.class})
@EnableConfigurationProperties(value={ExcelConfigProperties.class})
public class ExportExcelAutoConfiguration {
    private final RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private final ExportExcelReturnValueHandler exportExcelReturnValueHandler;

    @Bean
    @ConditionalOnMissingBean
    public NameProcessor nameProcessor() {
        return new NameSpelExpressionProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicNameAspect dynamicNameAspect(NameProcessor nameProcessor) {
        return new DynamicNameAspect(nameProcessor);
    }

    @PostConstruct
    public void setReturnValueHandlers() {
        List returnValueHandlers = this.requestMappingHandlerAdapter.getReturnValueHandlers();
        ArrayList<ExportExcelReturnValueHandler> newHandlers = new ArrayList<ExportExcelReturnValueHandler>();
        newHandlers.add(this.exportExcelReturnValueHandler);
        assert (returnValueHandlers != null);
        newHandlers.addAll(returnValueHandlers);
        this.requestMappingHandlerAdapter.setReturnValueHandlers(newHandlers);
    }

    @PostConstruct
    public void setRequestExcelArgumentResolver() {
        List argumentResolvers = this.requestMappingHandlerAdapter.getArgumentResolvers();
        ArrayList<ImportExcelArgumentResolver> resolverList = new ArrayList<ImportExcelArgumentResolver>();
        resolverList.add(new ImportExcelArgumentResolver());
        resolverList.addAll(argumentResolvers);
        this.requestMappingHandlerAdapter.setArgumentResolvers(resolverList);
    }

    public ExportExcelAutoConfiguration(RequestMappingHandlerAdapter requestMappingHandlerAdapter, ExportExcelReturnValueHandler exportExcelReturnValueHandler) {
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
        this.exportExcelReturnValueHandler = exportExcelReturnValueHandler;
    }
}

