/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.excel;

import cn.allbs.excel.aop.ExportExcelReturnValueHandler;
import cn.allbs.excel.config.ExcelConfigProperties;
import cn.allbs.excel.enhance.DefaultWriterBuilderEnhancer;
import cn.allbs.excel.enhance.WriterBuilderEnhancer;
import cn.allbs.excel.handle.ManySheetWriteHandler;
import cn.allbs.excel.handle.SheetWriteHandler;
import cn.allbs.excel.handle.SingleSheetWriteHandler;
import cn.allbs.excel.head.I18nHeaderCellWriteHandler;
import com.alibaba.excel.converters.Converter;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExcelHandlerConfiguration {
    private final ExcelConfigProperties configProperties;
    private final ObjectProvider<List<Converter<?>>> converterProvider;

    @Bean
    @ConditionalOnMissingBean
    public WriterBuilderEnhancer writerBuilderEnhancer() {
        return new DefaultWriterBuilderEnhancer();
    }

    @Bean
    @ConditionalOnMissingBean
    public SingleSheetWriteHandler singleSheetWriteHandler() {
        return new SingleSheetWriteHandler(this.configProperties, this.converterProvider, this.writerBuilderEnhancer());
    }

    @Bean
    @ConditionalOnMissingBean
    public ManySheetWriteHandler manySheetWriteHandler() {
        return new ManySheetWriteHandler(this.configProperties, this.converterProvider, this.writerBuilderEnhancer());
    }

    @Bean
    @ConditionalOnMissingBean
    public ExportExcelReturnValueHandler responseExcelReturnValueHandler(List<SheetWriteHandler> sheetWriteHandlerList) {
        return new ExportExcelReturnValueHandler(sheetWriteHandlerList);
    }

    @Bean
    @ConditionalOnBean(value={MessageSource.class})
    @ConditionalOnMissingBean
    public I18nHeaderCellWriteHandler i18nHeaderCellWriteHandler(MessageSource messageSource) {
        return new I18nHeaderCellWriteHandler(messageSource);
    }

    public ExcelHandlerConfiguration(ExcelConfigProperties configProperties, ObjectProvider<List<Converter<?>>> converterProvider) {
        this.configProperties = configProperties;
        this.converterProvider = converterProvider;
    }
}

