/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.excel.aop;

import cn.allbs.excel.annotation.ExportExcel;
import cn.allbs.excel.processor.NameProcessor;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
public class DynamicNameAspect {
    public static final String EXCEL_NAME_KEY = "__EXCEL_NAME_KEY__";
    private final NameProcessor processor;

    @Before(value="@annotation(excel)")
    public void around(JoinPoint point, ExportExcel excel) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        String name = this.processor.doDetermineName(point.getArgs(), ms.getMethod(), excel.name());
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Objects.requireNonNull(requestAttributes).setAttribute(EXCEL_NAME_KEY, (Object)name, 0);
    }

    public DynamicNameAspect(NameProcessor processor) {
        this.processor = processor;
    }
}

