/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.excel.aop;

import cn.allbs.excel.annotation.ImportExcel;
import cn.allbs.excel.handle.ListAnalysisEventListener;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class RequestExcelArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(RequestExcelArgumentResolver.class);

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(ImportExcel.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest webRequest, WebDataBinderFactory webDataBinderFactory) {
        Object inputStream;
        Class parameterType = parameter.getParameterType();
        if (!parameterType.isAssignableFrom(List.class)) {
            throw new IllegalArgumentException("Excel upload request resolver error, @RequestExcel parameter is not List " + parameterType);
        }
        ImportExcel importExcel = (ImportExcel)parameter.getParameterAnnotation(ImportExcel.class);
        assert (importExcel != null);
        Class<? extends ListAnalysisEventListener<?>> readListenerClass = importExcel.readListener();
        ListAnalysisEventListener readListener = (ListAnalysisEventListener)((Object)BeanUtils.instantiateClass(readListenerClass));
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        assert (request != null);
        if (request instanceof MultipartRequest) {
            MultipartFile file = ((MultipartRequest)request).getFile(importExcel.fileName());
            assert (file != null);
            inputStream = file.getInputStream();
        } else {
            inputStream = request.getInputStream();
        }
        Class excelModelClass = ResolvableType.forMethodParameter((MethodParameter)parameter).getGeneric(new int[]{0}).resolve();
        EasyExcel.read((InputStream)inputStream, (Class)excelModelClass, (ReadListener)readListener).ignoreEmptyRow(Boolean.valueOf(importExcel.ignoreEmptyRow())).sheet().doRead();
        WebDataBinder dataBinder = webDataBinderFactory.createBinder(webRequest, readListener.getErrors(), "excel");
        ModelMap model = modelAndViewContainer.getModel();
        model.put((Object)(BindingResult.MODEL_KEY_PREFIX + "excel"), (Object)dataBinder.getBindingResult());
        return readListener.getList();
    }
}

