/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.database.config;

import cn.allbs.database.config.DruidDataSourceProperties;
import com.baomidou.dynamic.datasource.provider.AbstractJdbcDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class JdbcDynamicDataSourceProvider
extends AbstractJdbcDataSourceProvider {
    private final DruidDataSourceProperties properties;

    public JdbcDynamicDataSourceProvider(DruidDataSourceProperties properties) {
        super(properties.getDriverClassName(), properties.getUrl(), properties.getUsername(), properties.getPassword());
        this.properties = properties;
    }

    protected Map<String, DataSourceProperty> executeStmt(Statement statement) throws SQLException {
        ResultSet rs = statement.executeQuery(this.properties.getQueryDsSql());
        HashMap<String, DataSourceProperty> map = new HashMap<String, DataSourceProperty>(8);
        while (rs.next()) {
            String name = rs.getString("name");
            String username = rs.getString("username");
            String password = rs.getString("password");
            String url = rs.getString("url");
            DataSourceProperty property = new DataSourceProperty();
            property.setUsername(username);
            property.setPassword(password);
            property.setUrl(url);
            map.put(name, property);
        }
        DataSourceProperty property = new DataSourceProperty();
        property.setUsername(this.properties.getUsername());
        property.setPassword(this.properties.getPassword());
        property.setUrl(this.properties.getUrl());
        property.setDriverClassName("com.mysql.cj.jdbc.Driver");
        map.put("master", property);
        return map;
    }
}

