/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.handle;

import cn.allbs.common.code.IResultCode;
import cn.allbs.common.code.SystemCode;
import cn.allbs.common.utils.R;
import cn.allbs.core.handle.IgnoreUrlProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
@EnableConfigurationProperties(value={IgnoreUrlProperties.class})
public class ResponseControllerAdvice
implements ResponseBodyAdvice<Object> {
    private final IgnoreUrlProperties ignoreUrlProperties;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> aClass) {
        return !Objects.requireNonNull(returnType.getMethod()).getReturnType().equals(R.class);
    }

    private boolean ignoring(String uri) {
        for (String string : this.ignoreUrlProperties.getUrls()) {
            if (!uri.contains(string)) continue;
            return true;
        }
        return false;
    }

    public Object beforeBodyWrite(Object data, MethodParameter returnType, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (this.ignoring(serverHttpRequest.getURI().toString())) {
            return data;
        }
        if (returnType.getGenericParameterType().equals(String.class)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString((Object)R.ok((Object)data));
            }
            catch (JsonProcessingException e) {
                return R.fail((IResultCode)SystemCode.FAILURE);
            }
        }
        return R.ok((Object)data);
    }

    public ResponseControllerAdvice(IgnoreUrlProperties ignoreUrlProperties) {
        this.ignoreUrlProperties = ignoreUrlProperties;
    }
}

