/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.advice;

import cn.allbs.common.code.IResultCode;
import cn.allbs.common.code.SystemCode;
import cn.allbs.common.context.DefaultAllbsContext;
import cn.allbs.common.context.IContext;
import cn.allbs.common.enums.ErrorType;
import cn.allbs.common.exception.ServiceException;
import cn.allbs.common.utils.AllbsWebUtils;
import cn.allbs.common.utils.R;
import cn.allbs.common.utils.StringUtil;
import cn.allbs.core.advice.AllbsErrorEvent;
import cn.allbs.core.util.ErrorUtil;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.DispatcherServlet;

@Order
@RestControllerAdvice
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class AllbsExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(AllbsExceptionTranslator.class);
    private final IContext iContent;
    private final ApplicationEventPublisher publisher;

    @Autowired
    public AllbsExceptionTranslator(ObjectProvider<IContext> allbsContextProvider, ApplicationEventPublisher publisher) {
        this.iContent = (IContext)allbsContextProvider.getIfAvailable(DefaultAllbsContext::new);
        this.publisher = publisher;
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<Object> handleError(ServiceException e) {
        log.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
        R result = e.getResult();
        if (result == null) {
            result = R.fail((IResultCode)SystemCode.FAILURE, (String)e.getMessage());
            this.publishEvent((Throwable)e);
        }
        return result;
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<Object> handleError(Throwable e) {
        log.error("\u672a\u77e5\u5f02\u5e38", e);
        this.publishEvent(e);
        return R.fail((IResultCode)SystemCode.FAILURE);
    }

    private void publishEvent(Throwable error) {
        AllbsErrorEvent event = new AllbsErrorEvent();
        event.setErrorType(ErrorType.REQUEST);
        event.setRequestId(this.iContent.getRequestId());
        HttpServletRequest request = AllbsWebUtils.getRequest();
        event.setRequestMethod(request.getMethod());
        String requestUrl = request.getRequestURI();
        String queryString = request.getQueryString();
        if (StringUtil.isNotBlank((CharSequence)queryString)) {
            requestUrl = requestUrl + "?" + queryString;
        }
        event.setRequestIp(AllbsWebUtils.getIP((HttpServletRequest)request));
        event.setRequestUrl(requestUrl);
        ErrorUtil.initErrorInfo(error, event);
        this.publisher.publishEvent((Object)event);
    }
}

