/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.config;

import cn.allbs.common.enums.PropertiesEnum;
import cn.hutool.core.util.StrUtil;
import io.netty.resolver.HostsFileParser;
import java.net.Inet4Address;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.StandardServletEnvironment;

@Configuration(proxyBeanMethods=false)
public class StartedEventListener {
    private static final Logger log = LoggerFactory.getLogger(StartedEventListener.class);

    @Async
    @Order(value=0x7FFFFFFE)
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        Environment environment = context.getEnvironment();
        String appName = environment.getRequiredProperty("spring.application.name");
        int localPort = event.getWebServer().getPort();
        String profile = StringUtils.arrayToCommaDelimitedString((Object[])environment.getActiveProfiles());
        log.info("-----------------------------\u7cfb\u7edf\u4fe1\u606f-------------------------------");
        log.info("\u5f53\u524d\u670d\u52a1[{}}]\u542f\u52a8\u5b8c\u6210,\u4f7f\u7528\u7684\u7aef\u53e3:[{}}],\u73af\u5883\u53d8\u91cf:[{}}]", new Object[]{appName, localPort, profile});
        if (!"prod".equals(profile)) {
            if (ClassUtils.isPresent((String)"springfox.documentation.spring.web.plugins.Docket", null) || ClassUtils.isPresent((String)"io.swagger.v3.oas.models.OpenAPI", null)) {
                log.info("\u5f53\u524d\u670d\u52a1swagger\u6587\u6863\u8bbf\u95ee\u8def\u5f84\u4e3a[http://localhost:{}/doc.html]", (Object)localPort);
            } else {
                log.info("\u5f53\u524d\u670d\u52a1uri\u57fa\u7840\u8def\u5f84\u4e3a[http://localhost:{}]", (Object)localPort);
            }
            Map environmentMap = ((StandardServletEnvironment)environment).getSystemEnvironment();
            Map systemProperties = ((StandardServletEnvironment)environment).getSystemProperties();
            Map stringInet4AddressMap = HostsFileParser.parseSilently().inet4Entries();
            block7: for (PropertiesEnum properties : PropertiesEnum.values()) {
                switch (properties.getType()) {
                    case SYSTEM: {
                        if (!systemProperties.containsKey(properties.getProperties())) continue block7;
                        log.info(properties.getDesc(), (Object)environment.getRequiredProperty(properties.getProperties()));
                        continue block7;
                    }
                    case IP: {
                        if (!environment.containsProperty(properties.getProperties())) continue block7;
                        String ip = environment.getRequiredProperty(properties.getProperties());
                        if (stringInet4AddressMap.containsKey(ip)) {
                            ip = ((Inet4Address)stringInet4AddressMap.get(ip)).getHostAddress();
                        }
                        log.info(properties.getDesc(), (Object)ip);
                        continue block7;
                    }
                    case URL: {
                        if (!environment.containsProperty(properties.getProperties())) continue block7;
                        String url = environment.getRequiredProperty(properties.getProperties());
                        String server = StrUtil.subBetween((CharSequence)url, (CharSequence)"//", (CharSequence)":");
                        if (stringInet4AddressMap.containsKey(server)) {
                            String hostServer = ((Inet4Address)stringInet4AddressMap.get(server)).getHostAddress();
                            url = url.replace(server, hostServer);
                        }
                        log.info(properties.getDesc(), (Object)url);
                        continue block7;
                    }
                    case HAS_VALUE: {
                        String defaultValue = properties.getDefaultValue();
                        if (environment.containsProperty(properties.getProperties())) {
                            defaultValue = environment.getRequiredProperty(properties.getProperties());
                        }
                        log.info(properties.getDesc(), (Object)defaultValue);
                        continue block7;
                    }
                    case TRUE_OR_FALSE_TRANSLATE: {
                        if (!environment.containsProperty(properties.getProperties())) continue block7;
                        log.info(properties.getDesc(), (Object)("true".equals(environment.getRequiredProperty(properties.getProperties())) ? "\u662f" : "\u5426"));
                        continue block7;
                    }
                    default: {
                        if (!environment.containsProperty(properties.getProperties())) continue block7;
                        log.info(properties.getDesc(), (Object)environment.getRequiredProperty(properties.getProperties()));
                    }
                }
            }
            log.info("-----------------------------\u7cfb\u7edf\u4fe1\u606f-------------------------------");
        }
    }
}

