/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.advice;

import cn.allbs.common.code.IResultCode;
import cn.allbs.common.code.SystemCode;
import cn.allbs.common.utils.R;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

@Order(value=-2147483648)
@Configuration(proxyBeanMethods=false)
@RestControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class RestExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionTranslator.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<Object> handleError(MissingServletRequestParameterException e) {
        log.warn("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570:{}", (Object)e.getMessage());
        String message = String.format("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570: %s", e.getParameterName());
        return R.fail((IResultCode)SystemCode.PARAM_MISS, (String)message);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<Object> handleError(MethodArgumentTypeMismatchException e) {
        log.warn("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef:{}", (Object)e.getMessage());
        String message = String.format("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef: %s", e.getName());
        return R.fail((IResultCode)SystemCode.PARAM_TYPE_ERROR, (String)message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<Object> handleError(MethodArgumentNotValidException e) {
        log.warn("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25:{}", (Object)e.getMessage());
        return RestExceptionTranslator.handleError(e.getBindingResult());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<Object> handleError(BindException e) {
        log.warn("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25:{}", (Object)e.getMessage());
        return RestExceptionTranslator.handleError(e.getBindingResult());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<Object> handleError(ConstraintViolationException e) {
        log.warn("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25:{}", (Object)e.getMessage());
        return RestExceptionTranslator.handleError(e.getConstraintViolations());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public R<Object> handleError(NoHandlerFoundException e) {
        log.error("404\u6ca1\u627e\u5230\u8bf7\u6c42:{}", (Object)e.getMessage());
        return R.fail((IResultCode)SystemCode.NOT_FOUND, (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<Object> handleError(HttpMessageNotReadableException e) {
        log.error("\u6d88\u606f\u4e0d\u80fd\u8bfb\u53d6:{}", (Object)e.getMessage());
        return R.fail((IResultCode)SystemCode.MSG_NOT_READABLE, (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public R<Object> handleError(HttpRequestMethodNotSupportedException e) {
        log.error("\u4e0d\u652f\u6301\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5:{}", (Object)e.getMessage());
        return R.fail((IResultCode)SystemCode.METHOD_NOT_SUPPORTED, (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public R<Object> handleError(HttpMediaTypeNotSupportedException e) {
        log.error("\u4e0d\u652f\u6301\u5f53\u524d\u5a92\u4f53\u7c7b\u578b:{}", (Object)e.getMessage());
        return R.fail((IResultCode)SystemCode.MEDIA_TYPE_NOT_SUPPORTED, (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public R<Object> handleError(HttpMediaTypeNotAcceptableException e) {
        String message = e.getMessage() + " " + e.getSupportedMediaTypes();
        log.error("\u4e0d\u63a5\u53d7\u7684\u5a92\u4f53\u7c7b\u578b:{}", (Object)message);
        return R.fail((IResultCode)SystemCode.MEDIA_TYPE_NOT_SUPPORTED, (String)message);
    }

    private static R<Object> handleError(BindingResult result) {
        FieldError error = result.getFieldError();
        String message = String.format("%s:%s", error.getField(), error.getDefaultMessage());
        return R.fail((IResultCode)SystemCode.PARAM_BIND_ERROR, (String)message);
    }

    private static R<Object> handleError(Set<ConstraintViolation<?>> violations) {
        ConstraintViolation<?> violation = violations.iterator().next();
        String path = ((PathImpl)violation.getPropertyPath()).getLeafNode().getName();
        String message = String.format("%s:%s", path, violation.getMessage());
        return R.fail((IResultCode)SystemCode.PARAM_VALID_ERROR, (String)message);
    }
}

