/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.util;

import cn.allbs.common.exception.Exceptions;
import cn.allbs.common.utils.ObjectUtil;
import cn.allbs.core.advice.AllbsErrorEvent;
import java.time.LocalDateTime;

public class ErrorUtil {
    public static void initErrorInfo(Throwable error, AllbsErrorEvent event) {
        event.setStackTrace(Exceptions.getStackTraceAsString((Throwable)error));
        event.setExceptionName(error.getClass().getName());
        event.setMessage(error.getMessage());
        event.setCreatedAt(LocalDateTime.now());
        Object[] elements = error.getStackTrace();
        if (ObjectUtil.isNotEmpty((Object[])elements)) {
            Object element = elements[0];
            event.setClassName(((StackTraceElement)element).getClassName());
            event.setFileName(((StackTraceElement)element).getFileName());
            event.setMethodName(((StackTraceElement)element).getMethodName());
            event.setLineNumber(((StackTraceElement)element).getLineNumber());
        }
    }
}

