/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.config;

import cn.allbs.common.log.LogPrintStream;
import cn.allbs.common.utils.SystemUtil;
import java.io.PrintStream;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
public class StartedEventListener {
    @Async
    @Order(value=0x7FFFFFFE)
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        Environment environment = context.getEnvironment();
        String appName = environment.getRequiredProperty("spring.application.name");
        int localPort = event.getWebServer().getPort();
        String profile = StringUtils.arrayToCommaDelimitedString((Object[])environment.getActiveProfiles());
        System.err.printf("---[%s]---\u542f\u52a8\u5b8c\u6210\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u7aef\u53e3:[%d]\uff0c\u73af\u5883\u53d8\u91cf:[%s]---%n", appName, localPort, profile);
        if (ClassUtils.isPresent((String)"springfox.documentation.spring.web.plugins.Docket", null)) {
            System.out.printf("http://localhost:%s/doc.html%n", localPort);
        } else {
            System.out.printf("http://localhost:%s%n", localPort);
        }
        if (SystemUtil.isLinux()) {
            System.setOut((PrintStream)LogPrintStream.log((boolean)false));
        }
    }
}

