/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.advice;

import cn.allbs.common.code.IResultCode;
import cn.allbs.common.code.SystemCode;
import cn.allbs.common.exception.ServiceException;
import cn.allbs.common.utils.R;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.WebRequest;

public class AllbsErrorAttributes
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(AllbsErrorAttributes.class);

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, ErrorAttributeOptions options) {
        R result;
        String requestUrl = (String)this.getAttr(webRequest, "javax.servlet.error.request_uri");
        if (StrUtil.isBlank((CharSequence)requestUrl)) {
            requestUrl = (String)this.getAttr(webRequest, "javax.servlet.forward.request_uri");
        }
        Integer status = (Integer)this.getAttr(webRequest, "javax.servlet.error.status_code");
        Throwable error = this.getError(webRequest);
        log.error("URL:{} error status:{}", new Object[]{requestUrl, status, error});
        if (error instanceof ServiceException) {
            result = ((ServiceException)error).getResult();
            result = Optional.ofNullable(result).orElse(R.fail((IResultCode)SystemCode.FAILURE));
        } else {
            result = R.fail((IResultCode)SystemCode.FAILURE, (String)("System error status:" + status));
        }
        return BeanUtil.beanToMap((Object)result);
    }

    @Nullable
    private <T> T getAttr(WebRequest webRequest, String name) {
        return (T)webRequest.getAttribute(name, 0);
    }
}

