package cn.allbs.core.config;

import cn.allbs.common.log.LogPrintStream;
import cn.allbs.common.utils.SystemUtil;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/**
 * @author ChenQi
 */
@Configuration(proxyBeanMethods = false)
public class StartedEventListener {

    @Async
    @Order(Ordered.LOWEST_PRECEDENCE - 1)
    @EventListener(WebServerInitializedEvent.class)
    public void afterStart(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        Environment environment = context.getEnvironment();
        String appName = environment.getRequiredProperty("spring.application.name");
        int localPort = event.getWebServer().getPort();
        String profile = StringUtils.arrayToCommaDelimitedString(environment.getActiveProfiles());
        System.err.printf("---[%s]---启动完成，当前使用的端口:[%d]，环境变量:[%s]---%n", appName, localPort, profile);
        // 如果有 swagger，打印开发阶段的 swagger ui 地址
        if (ClassUtils.isPresent("springfox.documentation.spring.web.plugins.Docket", null)) {
            System.out.printf("http://localhost:%s/doc.html%n", localPort);
        } else {
            System.out.printf("http://localhost:%s%n", localPort);
        }
        // linux 上将全部的 System.err 和 System.out 替换为log
        if (SystemUtil.isLinux()) {
            System.setOut(LogPrintStream.log(false));
        }
    }

}
