/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.util;

import cn.allbs.common.exception.Exceptions;
import cn.allbs.common.utils.Base64Util;
import cn.allbs.common.utils.ImageUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;

public final class QrCode {
    private final String content;
    private int size;
    private Charset encode;
    private ErrorCorrectionLevel errorCorrectionLevel;
    private double errorCorrectionLevelValue;
    private Color foreGroundColor;
    private Color backGroundColor;
    private String imageFormat;
    private boolean deleteMargin;
    private final Hashtable<EncodeHintType, Object> hints;
    private BufferedImage logo;

    private QrCode(String content) {
        this.content = content;
        this.size = 512;
        this.encode = StandardCharsets.UTF_8;
        this.errorCorrectionLevel = ErrorCorrectionLevel.M;
        this.errorCorrectionLevelValue = 0.15;
        this.foreGroundColor = Color.BLACK;
        this.backGroundColor = Color.WHITE;
        this.imageFormat = "png";
        this.deleteMargin = true;
        this.hints = new Hashtable();
    }

    public static QrCode form(String content) {
        return new QrCode(content);
    }

    public QrCode size(int size) {
        this.size = size;
        return this;
    }

    public QrCode encode(Charset encode) {
        if (null != encode) {
            this.encode = encode;
        }
        return this;
    }

    public QrCode errorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) {
        switch (errorCorrectionLevel) {
            case L: {
                this.errorCorrectionLevel = errorCorrectionLevel;
                this.errorCorrectionLevelValue = 0.07;
                break;
            }
            case M: {
                this.errorCorrectionLevel = errorCorrectionLevel;
                this.errorCorrectionLevelValue = 0.15;
                break;
            }
            case Q: {
                this.errorCorrectionLevel = errorCorrectionLevel;
                this.errorCorrectionLevelValue = 0.25;
                break;
            }
            case H: {
                this.errorCorrectionLevel = errorCorrectionLevel;
                this.errorCorrectionLevelValue = 0.3;
                break;
            }
            default: {
                this.errorCorrectionLevel = ErrorCorrectionLevel.M;
                this.errorCorrectionLevelValue = 0.15;
            }
        }
        return this;
    }

    public QrCode foreGroundColor(String foreGroundColor) {
        try {
            this.foreGroundColor = QrCode.getColor(foreGroundColor);
        }
        catch (NumberFormatException e) {
            this.foreGroundColor = Color.BLACK;
        }
        return this;
    }

    public QrCode foreGroundColor(Color foreGroundColor) {
        this.foreGroundColor = foreGroundColor;
        return this;
    }

    public QrCode backGroundColor(String backGroundColor) {
        try {
            this.backGroundColor = QrCode.getColor(backGroundColor);
        }
        catch (NumberFormatException e) {
            this.backGroundColor = Color.WHITE;
        }
        return this;
    }

    public QrCode backGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
        return this;
    }

    public QrCode imageFormat(String imageFormat) {
        if (imageFormat != null) {
            this.imageFormat = imageFormat.toLowerCase();
        }
        return this;
    }

    public QrCode deleteMargin(boolean deleteMargin) {
        this.deleteMargin = deleteMargin;
        return this;
    }

    public Hashtable<EncodeHintType, ?> getHints() {
        this.hints.clear();
        this.hints.put(EncodeHintType.ERROR_CORRECTION, this.errorCorrectionLevel);
        this.hints.put(EncodeHintType.CHARACTER_SET, this.encode);
        this.hints.put(EncodeHintType.MARGIN, 0);
        return this.hints;
    }

    public QrCode logo(BufferedImage logo) {
        this.logo = logo;
        return this;
    }

    public QrCode logo(File logo) {
        return this.logo(ImageUtil.read((File)logo));
    }

    public QrCode logo(URL url) {
        return this.logo(ImageUtil.read((URL)url));
    }

    public QrCode logo(String iconPath) {
        return this.logo(ImageUtil.read((String)iconPath));
    }

    public QrCode logo(InputStream logoStream) {
        return this.logo(ImageUtil.read((InputStream)logoStream));
    }

    public boolean write(OutputStream output) {
        BufferedImage bufferedImage = this.toImage();
        return ImageUtil.write((RenderedImage)bufferedImage, (String)this.imageFormat, (OutputStream)output);
    }

    public File toFile(String f) {
        return this.toFile(new File(f));
    }

    public File toFile(File qrCodeFile) {
        if (!qrCodeFile.exists()) {
            qrCodeFile.getParentFile().mkdirs();
        }
        BufferedImage bufferedImage = this.toImage();
        ImageUtil.write((RenderedImage)bufferedImage, (String)this.imageFormat, (File)qrCodeFile);
        return qrCodeFile;
    }

    public String toBase64() {
        return "data:image/png;base64," + Base64Util.encodeToString((byte[])this.toBytes());
    }

    public byte[] toBytes() {
        BufferedImage bufferedImage = this.toImage();
        return ImageUtil.writeAsBytes((RenderedImage)bufferedImage, (String)this.imageFormat);
    }

    public ByteArrayInputStream toStream() {
        BufferedImage bufferedImage = this.toImage();
        return ImageUtil.writeAsStream((RenderedImage)bufferedImage, (String)this.imageFormat);
    }

    public BufferedImage toImage() {
        BitMatrix matrix;
        String text = new String(this.content.getBytes(this.encode));
        try {
            matrix = new QRCodeWriter().encode(text, BarcodeFormat.QR_CODE, this.size, this.size, this.getHints());
        }
        catch (WriterException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
        if (this.deleteMargin) {
            matrix = QrCode.deleteWhite(matrix);
        }
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int fgColor = this.foreGroundColor.getRGB();
        int bgColor = this.backGroundColor.getRGB();
        BufferedImage image = new BufferedImage(width, height, 5);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? fgColor : bgColor);
            }
        }
        if (null != this.logo) {
            QrCode.addLogo(image, this.logo, this);
        }
        return image;
    }

    public static String read(String qrCodeFile) {
        return QrCode.read(ImageUtil.read((String)qrCodeFile));
    }

    public static String read(File qrCodeFile) {
        return QrCode.read(ImageUtil.read((File)qrCodeFile));
    }

    public static String read(URL qrCodeUrl) {
        return QrCode.read(ImageUtil.read((URL)qrCodeUrl));
    }

    public static String read(BufferedImage qrCodeImage) {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(qrCodeImage);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        try {
            Result result = new QRCodeReader().decode(bitmap);
            String string = result.getText();
            return string;
        }
        catch (ChecksumException | FormatException | NotFoundException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
        finally {
            qrCodeImage.getGraphics().dispose();
        }
    }

    private static void addLogo(BufferedImage qrCodeImage, BufferedImage logoImage, QrCode qrCode) {
        int baseWidth = qrCodeImage.getWidth();
        int baseHeight = qrCodeImage.getHeight();
        int maxWidth = (int)Math.sqrt((double)(baseWidth * baseHeight) * qrCode.errorCorrectionLevelValue * 0.4);
        int logoRectWidth = Math.min(maxWidth, logoImage.getWidth());
        int logoRectHeight = Math.min(maxWidth, logoImage.getHeight());
        BufferedImage logoRect = new BufferedImage(logoRectWidth, logoRectHeight, 2);
        Graphics2D g2 = logoRect.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, logoRectWidth, logoRectHeight);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(2, 2, logoRectWidth - 4, logoRectHeight - 4);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage(logoImage, 4, 4, logoRectWidth - 8, logoRectHeight - 8, null);
        logoImage.getGraphics().dispose();
        g2.dispose();
        Graphics2D gc = (Graphics2D)qrCodeImage.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setColor(qrCode.backGroundColor);
        gc.drawImage((Image)logoRect, (baseWidth - logoRectWidth) / 2, (baseHeight - logoRectHeight) / 2, null);
        gc.dispose();
    }

    private static Color getColor(String hexString) {
        if ('#' == hexString.charAt(0)) {
            return new Color(Long.decode(hexString).intValue());
        }
        return new Color(Long.decode("0xFF" + hexString).intValue());
    }

    private static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }
}

