/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.core.handle;

import cn.allbs.common.enums.ErrorCodeEnum;
import cn.allbs.common.exception.ParamCheckException;
import cn.allbs.common.utils.R;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandlerResolver {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerResolver.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> unKnowExceptionHandler(Exception e) {
        String timeNow = "EX-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> runtimeExceptionHandler(RuntimeException e) {
        String timeNow = "RE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.INTERNAL_SERVER_ERROR, (String)timeNow);
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> nullPointerExceptionHandler(NullPointerException e) {
        String timeNow = "NPE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.NULL_POINTER_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={ClassCastException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> classCastExceptionHandler(ClassCastException e) {
        String timeNow = "CCE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.CAST_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> iOExceptionHandler(IOException e) {
        String timeNow = "IOE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.IO_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={NoSuchMethodException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> noSuchMethodExceptionHandler(NoSuchMethodException e) {
        String timeNow = "NSUE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.NO_SUCH_METHOD_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={IndexOutOfBoundsException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> indexOutOfBoundsExceptionHandler(IndexOutOfBoundsException e) {
        String timeNow = "IOOBE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.INDEX_OUT_OF_BOUND_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<ErrorCodeEnum> requestNotReadable(HttpMessageNotReadableException e) {
        String timeNow = "HMNRE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.HTTP_MESSAGE_NOT_READABLE_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<ErrorCodeEnum> requestTypeMismatch(TypeMismatchException e) {
        String timeNow = "TME-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.TYPE_MISMATCH_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<ErrorCodeEnum> requestMissingServletRequest(MissingServletRequestParameterException e) {
        String timeNow = "MSRPE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.MISSING_SERVLET_REQUEST_PARAMETER_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<ErrorCodeEnum> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        String timeNow = "MANVE-" + System.currentTimeMillis();
        ArrayList<String> list = new ArrayList<String>();
        if (!e.getBindingResult().getAllErrors().isEmpty()) {
            for (ObjectError error : e.getBindingResult().getAllErrors()) {
                list.add(error.getDefaultMessage());
            }
        }
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + list, e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.METHOD_ARGUMENT_NOT_VALID_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={ParamCheckException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<ErrorCodeEnum> resolveMyException(ParamCheckException ex) {
        String timeNow = "PCE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + ex.getLocalizedMessage(), ex.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.METHOD_ARGUMENT_NOT_VALID_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public R<ErrorCodeEnum> request405(HttpRequestMethodNotSupportedException e) {
        String timeNow = "HRMNSE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.HTTP_REQUEST_METHOD_NOT_SUPPORTED_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public R<ErrorCodeEnum> request406(HttpMediaTypeNotAcceptableException e) {
        String timeNow = "HMTNAE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={ConversionNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> server500(ConversionNotSupportedException e) {
        String timeNow = "CNSE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.CONVERSION_NOT_ACCEPTABLE_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={HttpMessageNotWritableException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> server500(HttpMessageNotWritableException e) {
        String timeNow = "HMNWE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.CONVERSION_NOT_ACCEPTABLE_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public R<ErrorCodeEnum> httpMediaTypeNotSupportedExceptionHandler(HttpMediaTypeNotSupportedException e) {
        String timeNow = "HMTNSE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.HTTP_MEDIA_TYPE_NOT_SUPPORTED_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public R<ErrorCodeEnum> notFoundException(NoHandlerFoundException e) {
        String timeNow = "NHFE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.NO_HANDLER_FOUND_EXCEPTION_RESPONSE, (String)timeNow);
    }

    @ExceptionHandler(value={ServerErrorException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<ErrorCodeEnum> serverErrorExceptionHandler(ServerErrorException e) {
        String timeNow = "SEE-" + System.currentTimeMillis();
        log.error("allbs:\u5f02\u5e38\u62e6\u622a[" + timeNow + "]:" + e.getLocalizedMessage(), e.getCause());
        return R.exception((ErrorCodeEnum)ErrorCodeEnum.INTERNAL_SERVER_ERROR, (String)timeNow);
    }
}

