package cn.allbs.core.handle;

import cn.allbs.common.enums.ErrorCodeEnum;
import cn.allbs.common.utils.R;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * 功能: 统一封装返回结果
 *
 * @author ChenQi
 * @version 1.0
 * @since 2021/3/20 下午10:30
 */
@RequiredArgsConstructor
public class ResponseControllerAdvice implements ResponseBodyAdvice<Object> {

    private final IgnoreUrlProperties ignoreUrlProperties;

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> aClass) {
        // 如果接口返回的类型本身就是R那就没有必要进行额外的操作，返回false
        return !returnType.getGenericParameterType().equals(R.class);
    }

    /**
     * 判断url是否需要拦截
     *
     * @param uri
     * @return
     */
    private boolean ignoring(String uri) {
        for (String string : ignoreUrlProperties.getUrls()) {
            if (uri.contains(string)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object beforeBodyWrite(Object data, MethodParameter returnType, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        //判断url是否需要拦截
        if (this.ignoring(serverHttpRequest.getURI().toString())) {
            return data;
        }
        // String类型不能直接包装，所以要进行些特别的处理
        if (returnType.getGenericParameterType().equals(String.class)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString(R.ok(data));
            } catch (JsonProcessingException e) {
                return R.exception(ErrorCodeEnum.EXCEPTION_RESPONSE);
            }
        }
        // 将原本的数据包装在R里
        return R.ok(data);
    }
}
