package cn.allbs.captcha.utils;

import cn.allbs.captcha.core.AbstractCaptcha;
import cn.allbs.captcha.core.CaptchaDetails;
import cn.allbs.captcha.core.CaptchaInfo;
import cn.allbs.captcha.enums.CaptchaEnum;
import lombok.experimental.UtilityClass;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 验证码工具类
 *
 * @author ChenQi
 */
@UtilityClass
public class CaptchaUtil {

    /**
     * 获取验证码
     *
     * @param captchaDetails 构建验证码的条件
     * @return AbstractCaptcha
     */
    public AbstractCaptcha captcha(CaptchaDetails captchaDetails) {
        return CaptchaEnum.captchaType(captchaDetails);
    }

    /**
     * 输出验证码
     *
     * @param captchaDetails 构建验证码的条件
     * @param response       HttpServletResponse
     * @return 验证码
     */
    public String captcha(CaptchaDetails captchaDetails, HttpServletResponse response) {
        AbstractCaptcha captcha = CaptchaEnum.captchaType(captchaDetails);
        response.setContentType(captcha.getMimeType());
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);
        captcha.create();
        captcha.getImage();
        try {
            captcha.write(response.getOutputStream());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return captcha.getText();
    }

    /**
     * 获取默认验证码
     *
     * @return AbstractCaptcha
     */
    public AbstractCaptcha captcha() {
        return CaptchaEnum.captchaType(CaptchaInfo.builder().build());
    }

}
