package cn.allbs.captcha.core;

import cn.allbs.captcha.enums.CaptchaEnum;
import cn.allbs.captcha.enums.ImageEnum;
import lombok.ToString;

import java.awt.*;

/**
 * @author ChenQi
 */
@ToString
public class ChineseCaptchaInfo implements CaptchaDetails {

    private final int len;

    private final int width;

    private final int height;

    private final Font font;

    private final Color color;

    private final int type;

    private final int interfereCount;

    private final int imageType;

    ChineseCaptchaInfo(int len, int width, int height, Font font, Color color, int interfereCount, int imageType) {
        this.len = len;
        this.width = width;
        this.height = height;
        this.font = font;
        this.color = color;
        this.type = CaptchaEnum.CHINESE_ONLY.getType();
        this.interfereCount = interfereCount;
        this.imageType = imageType;
    }

    @Override
    public int len() {
        return this.len;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public Font font() {
        return this.font;
    }

    @Override
    public Color color() {
        return this.color;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public int interfereCount() {
        return this.interfereCount;
    }

    @Override
    public int imageType() {
        return this.imageType;
    }

    public static CaptchaInfoBuild builder() {
        return new CaptchaInfoBuild();
    }

    public static final class CaptchaInfoBuild {
        private int len = 4;

        private int width = 130;

        private int height = 48;

        private Font font = new Font("楷体", Font.PLAIN, 28);

        /**
         * 背景色默认白色
         */
        private Color color = new Color(255, 255, 255);

        private int interfereCount = 15;

        private int imageType = ImageEnum.GIF.getType();

        public CaptchaInfoBuild() {

        }

        /**
         * 设置验证码的边框大小及字符个数
         *
         * @param len    字符个数
         * @param width  长度
         * @param height 宽度
         * @return {@link CaptchaInfoBuild}
         */
        public CaptchaInfoBuild size(int len, int width, int height) {
            this.len = len;
            this.width = width;
            this.height = height;
            return this;
        }

        /**
         * 设置验证码的字体
         *
         * @param font 字体
         * @return {@link CaptchaInfoBuild}
         */
        public CaptchaInfoBuild font(Font font) {
            this.font = font;
            return this;
        }

        /**
         * 设置验证码的颜色
         *
         * @param color 颜色
         * @return {@link CaptchaInfoBuild}
         */
        public CaptchaInfoBuild color(Color color) {
            this.color = color;
            return this;
        }

        /**
         * 混淆数
         *
         * @return {@link CaptchaInfoBuild}
         */
        public CaptchaInfoBuild interfereCount(int interfereCount) {
            this.interfereCount = interfereCount;
            return this;
        }

        /**
         * 图片类型
         *
         * @param imageType 图片类型
         * @return {@link CaptchaInfoBuild}
         */
        public CaptchaInfoBuild imageType(int imageType) {
            this.imageType = imageType;
            return this;
        }

        public CaptchaDetails build() {
            return new ChineseCaptchaInfo(this.len, this.width, this.height,
                    this.font, this.color,
                    this.interfereCount, this.imageType);
        }
    }
}
