package cn.allbs.captcha.generator;

import cn.allbs.captcha.enums.AlphaEnum;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

/**
 * 中文字符验证码生成器
 *
 * @author ChenQi
 */
public class ChineseCaptchaGenerator extends AbstractCaptchaGenerator {
    public ChineseCaptchaGenerator(char[] baseChars, int len) {
        super(baseChars, len);
    }

    public ChineseCaptchaGenerator(int len) {
        super(AlphaEnum.CHINESE.getAlphas(), len);
    }

    @Override
    public char[] generator() {
        char[] codes = new char[this.len];
        for (int i = 0; i < this.len; i++) {
            codes[i] = this.baseChars[RandomUtil.randomInt(this.baseChars.length)];
        }
        return codes;
    }

    @Override
    public boolean verify(String generatorCode, String checkedCode) {
        if (StrUtil.isAllNotBlank(generatorCode, checkedCode)) {
            return StrUtil.equalsIgnoreCase(generatorCode, checkedCode);
        }
        return false;
    }
}
