package cn.allbs.captcha.generator;

import java.io.Serializable;

/**
 * 验证码生成器
 *
 * @author ChenQi
 */
public interface CaptchaGenerator extends Serializable {

    /**
     * 生成验证码
     *
     * @return 验证码
     */
    char[] generator();

    /**
     * 校验验证码
     *
     * @param generatorCode 生成的验证码
     * @param checkedCode   待验证的验证码
     * @return 是否一致
     */
    boolean verify(String generatorCode, String checkedCode);
}
