/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.generator;

import cn.allbs.captcha.engine.Symbol;
import cn.allbs.captcha.enums.AlphaEnum;
import cn.allbs.captcha.generator.AbstractCaptchaGenerator;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

public class NumberCountCaptchaGenerator
extends AbstractCaptchaGenerator {
    private static final String operators = "+-*";

    public NumberCountCaptchaGenerator(int len) {
        super(AlphaEnum.NUMBERS.getAlphas(), len == 0 ? 2 : len);
    }

    public NumberCountCaptchaGenerator() {
        this(2);
    }

    @Override
    public char[] generator() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.len; ++i) {
            sb.append(RandomUtil.randomInt((int)10));
            if (i >= this.len - 1) continue;
            int type = RandomUtil.randomInt((int)1, (int)4);
            if (type == 1) {
                sb.append(Symbol.ADD.getValue());
                continue;
            }
            if (type == 2) {
                sb.append(Symbol.SUB.getValue());
                continue;
            }
            if (type != 3) continue;
            sb.append(Symbol.MUL.getValue());
        }
        sb.append("=?");
        return sb.toString().toCharArray();
    }

    @Override
    public boolean verify(String generatorCode, String checkedCode) {
        if (StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{generatorCode, checkedCode})) {
            return StrUtil.equalsIgnoreCase((CharSequence)generatorCode, (CharSequence)checkedCode);
        }
        return false;
    }

    public int getLength() {
        return this.len * 2 + 2;
    }

    private int getLimit() {
        return Integer.parseInt("1" + StrUtil.repeat((char)'0', (int)this.len));
    }
}

