package cn.allbs.captcha.generator;

import cn.allbs.captcha.engine.Symbol;
import cn.allbs.captcha.enums.AlphaEnum;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

/**
 * 数字计算验证码生成器
 *
 * @author ChenQi
 */
public class NumberCountCaptchaGenerator extends AbstractCaptchaGenerator {

    private static final String operators = "+-*";

    public NumberCountCaptchaGenerator(int len) {
        super(AlphaEnum.NUMBERS.getAlphas(), len == 0 ? 2 : len);
    }

    public NumberCountCaptchaGenerator() {
        this(2);
    }

    @Override
    public char[] generator() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; i++) {
            sb.append(RandomUtil.randomInt(10));
            if (i < len - 1) {
                int type = RandomUtil.randomInt(1, 4);
                if (type == 1) {
                    sb.append(Symbol.ADD.getValue());
                } else if (type == 2) {
                    sb.append(Symbol.SUB.getValue());
                } else if (type == 3) {
                    sb.append(Symbol.MUL.getValue());
                }
            }
        }
        sb.append("=?");
        return sb.toString().toCharArray();
    }

    @Override
    public boolean verify(String generatorCode, String checkedCode) {
        if (StrUtil.isAllNotBlank(generatorCode, checkedCode)) {
            return StrUtil.equalsIgnoreCase(generatorCode, checkedCode);
        }
        return false;
    }

    /**
     * 获取验证码长度
     *
     * @return 验证码长度
     */
    public int getLength() {
        return this.len * 2 + 2;
    }

    /**
     * 根据长度获取参与计算数字最大值
     *
     * @return 最大值
     */
    private int getLimit() {
        return Integer.parseInt("1" + StrUtil.repeat('0', this.len));
    }
}
