package cn.allbs.captcha.enums;

import cn.allbs.captcha.captcha.*;
import cn.allbs.captcha.core.AbstractCaptcha;
import cn.allbs.captcha.core.CaptchaDetails;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 验证码类型枚举
 *
 * @author ChenQi
 */
@Getter
@RequiredArgsConstructor
public enum CaptchaEnum {

    /**
     * 数字字母混合
     */
    NUMBER_CHAR_MIXTURE(1) {
        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new NumberCharMixtureCaptcha(captchaDetails);
        }
    },

    /**
     * 纯数字
     */
    ONLY_NUMBER(2) {
        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new NumberCaptcha(captchaDetails);
        }
    },

    /**
     * 纯字母
     */
    ONLY_CHAR(3) {
        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new CharCaptcha(captchaDetails);
        }
    },

    /**
     * 纯大写字母
     */
    ONLY_UPPER_CHAR(4) {
        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new UpperCharCaptcha(captchaDetails);
        }

    },

    /**
     * 纯小写字母
     */
    ONLY_LOWER_CHAR(5) {
        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new LowerCharCaptcha(captchaDetails);
        }
    },

    /**
     * 中文字符
     */
    CHINESE_ONLY(6) {
        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new ChineseCaptcha(captchaDetails);
        }
    },

    /**
     * 数字计算
     */
    NUMBER_COUNT(7) {
        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new NumberCountCaptcha(captchaDetails);
        }
    };

    public abstract AbstractCaptcha execute(CaptchaDetails captchaDetails);

    private final Integer type;

    /**
     * 验证码类型
     *
     * @param captchaDetails 验证码码属性
     * @return
     */
    public static AbstractCaptcha captchaType(CaptchaDetails captchaDetails) {
        CaptchaEnum[] captchaEnums = CaptchaEnum.values();
        for (CaptchaEnum captchaEnum : captchaEnums) {
            if (captchaDetails.type() == captchaEnum.getType()) {
                return captchaEnum.execute(captchaDetails);
            }
        }
        return CaptchaEnum.NUMBER_CHAR_MIXTURE.execute(captchaDetails);
    }

}
