package cn.allbs.cache.properties;

import lombok.Data;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

/**
 * 功能: redis 配置
 *
 * @author ChenQi
 * @version 1.0
 * @since 2021/3/20
 */
@Data
public class RedisConfigProp {

    /**
     * 全局过期时间，默认不过期
     */
    private Duration defaultExpiration = Duration.ZERO;

    /**
     * 全局空值过期时间，默认和有值的过期时间一致，一般设置空值过期时间较短
     */
    private Duration defaultNullValuesExpiration = null;

    /**
     * 每个cacheName的过期时间，优先级比defaultExpiration高
     */
    private Map<String, Duration> expires = new HashMap<>();

    /**
     * 缓存更新时通知其他节点的topic名称
     */
    private String topic = "cache:redis:caffeine:topic";

    /**
     * 是否默认启用二级缓存
     */
    private boolean enable = true;

}
