package cn.allbs.cache.properties;

import cn.allbs.cache.enums.CaffeineStrength;
import lombok.Data;

import java.time.Duration;

/**
 * 功能: caffeine配置
 *
 * @author ChenQi
 * @version 1.0
 * @since 2021/3/20
 */
@Data
public class CaffeineConfigProp {

    /**
     * 访问后过期时间
     */
    private Duration expireAfterAccess;

    /**
     * 写入后过期时间
     */
    private Duration expireAfterWrite;

    /**
     * 写入后刷新时间
     */
    private Duration refreshAfterWrite;

    /**
     * 初始化大小
     */
    private int initialCapacity;

    /**
     * 最大缓存对象个数，超过此数量时之前放入的缓存将失效
     */
    private long maximumSize;

    /**
     * key 强度
     */
    private CaffeineStrength keyStrength;

    /**
     * value 强度
     */
    private CaffeineStrength valueStrength;

    /**
     * 是否使用caffeine cache 默认为使用
     */
    private boolean enable = true;

}
