package cn.allbs.cache.properties;

import lombok.Data;

/**
 * 功能: caffeine配置
 *
 * @author ChenQi
 * @version 1.0
 * @since 2021/3/20
 */
@Data
public class CaffeineConfigProp {

    /**
     * 访问后过期时间，单位毫秒
     */
    private long expireAfterAccess;

    /**
     * 写入后过期时间，单位毫秒
     */
    private long expireAfterWrite;

    /**
     * 写入后刷新时间，单位毫秒
     */
    private long refreshAfterWrite;

    /**
     * 初始化大小
     */
    private int initialCapacity;

    /**
     * 最大缓存对象个数，超过此数量时之前放入的缓存将失效
     */
    private long maximumSize;

    /**
     * 是否使用caffeine cache 默认为使用
     */
    private boolean usedCaffeineCache = true;

}
