package ${package.ServiceImpl};

import cn.airfei.aircore.core.properties.AirCoreProperty;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.airfei.aircore.core.utils.QueryParamUtil;
import ${Entity}.${entity};
import ${Mapper}.${table.mapperName};
import ${package.Service}.${table.serviceName};
import ${superServiceImplClassPackage};
import ${Dto}.${entity}Dto;
import ${Vo}.${entity}Vo;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.math.NumberUtils;
import cn.airfei.aircore.core.constants.AirStatusConstants;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import cn.airfei.aircore.core.storage.PageParam;

/**
 * <p>
 * ${table.comment!}
 * </p>
 *
 * @author ${author}
 * @since ${date}
 */
@Service
<#if kotlin>
open class ${table.serviceImplName} : ${superServiceImplClass}<${table.mapperName}, ${entity}>(), ${table.serviceName} {

}
<#else>
public class ${table.serviceImplName} extends ${superServiceImplClass}<${table.mapperName}, ${entity}> implements ${table.serviceName} {
    @Resource
    private AirCoreProperty airCoreProperty;

    @Resource
    private ${table.mapperName} ${table.mapperName?uncap_first};


    /**
     *   
     * @param ${entity?uncap_first}Dto
     * @param pageParam
     * @return
     */
    @Override
    public Page<${entity}Vo> index(${entity}Dto ${entity?uncap_first}Dto,PageParam pageParam) {
        Page<${entity}Dto> page=new Page<>(pageParam.getPageCurrent(),pageParam.getPageSize());
        return ${table.mapperName?uncap_first}.index(page,${entity?uncap_first}Dto,pageParam);
    }

    /**
     * 分页查询单表数据
     *
     * @param map
     * @return
     */
    @Override
    public Page<${entity}> singleTablePage(Map<String, Object> map) {
        QueryWrapper<${entity}> queryWrapper= QueryParamUtil.getEntityWrapper(map,${entity}.class);
        queryWrapper.lambda().orderByDesc(${entity}::getId);
        Page<${entity}> page=new Page<>(Long.parseLong(String.valueOf(map.get("pageCurrent"))),Long.parseLong(String.valueOf(map.get("pageSize"))));
        return ${table.mapperName?uncap_first}.selectPage(page,queryWrapper);
    }

    /**
     * 显示单条数据
     *
     * @param id
     * @return
     */
    @Override
    public ${entity} show(String id){
        QueryWrapper<${entity}> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("id",id);
        return ${table.mapperName?uncap_first}.selectOne(queryWrapper);
    }

    /**
     * 删除（销毁表数据）,逻辑删除,设置status为-1
     *
     * @param ids
     * @return
     */
    @Override
    public Integer destroy(String ids){
        List<Long> idLongList = Arrays.asList(ids.split(",")).stream()
            .map(s -> NumberUtils.createLong(s.trim())).collect(Collectors.toList());

        QueryWrapper<${entity}> queryWrapper=new QueryWrapper();
        queryWrapper.in("id",idLongList);
        ${entity} ${entity?uncap_first}=new ${entity}();
        ${entity?uncap_first}.setStatus(AirStatusConstants.delete);
        return ${table.mapperName?uncap_first}.update(${entity?uncap_first},queryWrapper);
    }

    /**
     * 更新表数据
     *
     * @param ${entity?uncap_first}
     * @return
     */
    @Override
    public Integer update(${entity} ${entity?uncap_first}){
        return ${table.mapperName?uncap_first}.updateById(${entity?uncap_first});
    }

    /**
     * 保存表数据
     *
     * @param ${entity?uncap_first}
     * @return
     */
    @Override
    public Integer store(${entity} ${entity?uncap_first}){
        return ${table.mapperName?uncap_first}.insert(${entity?uncap_first});
    }

    /**
     * 设置状态，1：正常，0：禁用
     *
     * @param id
     * @param status
     * @return
     */
    @Override
    public Integer setStatus(<#list table.fields as field><#if field.keyFlag>${field.propertyType}</#if></#list> id, Integer status) {
        ${entity} ${entity?uncap_first}=new ${entity}();
        ${entity?uncap_first}.setId(id);
        ${entity?uncap_first}.setStatus(status);
        return ${table.mapperName?uncap_first}.updateById(${entity?uncap_first});
    }

    /**
     * get all resource in storage
     * @return
     */
    @Override
    public List<${entity}> getAll${entity}() {
        QueryWrapper<${entity}> queryWrapper=new QueryWrapper();
        queryWrapper.lambda()
            .orderByDesc(${entity}::getId)
            .last("limit " + airCoreProperty.getMaxSelect());
        return ${table.mapperName?uncap_first}.selectList(queryWrapper);
    }

    /**
     * get list in single table
     *
     * @param map
     * @return
     */
    @Override
    public List<${entity}> getSingleTableList(Map map) {
        QueryWrapper<${entity}> queryWrapper = QueryParamUtil.getEntityWrapper(map, ${entity}.class);
        queryWrapper.lambda().orderByDesc(${entity}::getId).last("limit " + airCoreProperty.getMaxSelect());
        return ${table.mapperName?uncap_first}.selectList(queryWrapper);
    }

}
</#if>
