package cn.airfei.aircore.core.utils;


import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.Map;

/**
 * @description: map 或 object 转成 MultiValueMap
 * @author: air
 * @create: 2019-06-17 16:20
 **/
public class ConvertToMultiValueMapUtil<T> {

    public static MultiValueMap mapToMultiValueMap(Map map) {
        return traMapToMultiValueMap(map);
    }

    /**
     * 对象转 MultiValueMap
     *
     * @param object
     * @return
     */
    public static MultiValueMap objectToMultiValueMap(Object object) {
        Map map = JSONObject.parseObject(JSON.toJSONString(object));
        return traMapToMultiValueMap(map);
    }


    /**
     * 遍历map 并 add 到 MultiValueMap中
     *
     * @param map
     * @return
     */
    private static MultiValueMap traMapToMultiValueMap(Map map) {
        MultiValueMap multiValueMap = new LinkedMultiValueMap<>();
        for (Object m : map.keySet()) {
            multiValueMap.add(m, String.valueOf(map.get(m)));
        }
        return multiValueMap;
    }
}
