package cn.airfei.aircore.core.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: air
 * @create: 2019-12-30 17:37
 **/
@Component
@ConfigurationProperties(prefix = "air.core.generator")
@Data
public class CodeGeneratorProperty {
    private String author;

    private String outputDir;

    private String parent;

    private String entity;

    private String service;

    private String serviceImpl;

    private String ServiceName;

    private String serviceImplName;

    // 模块名称
    private String moduleName = "";

    // 模块路径
    private String modulePath;

    private String tablePrefix;

    private String includeTables;

    private String excludeTables;

    private String projectPath = System.getProperty("user.dir");

    private String groupId;

    private String artifactId;

    private String version="1.0";




}
