package cn.airfei.aircore.core.generator;

import cn.airfei.aircore.core.properties.CodeGeneratorProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.baomidou.mybatisplus.generator.function.ConverterFileName;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

/**
 * @description: 自动生成代码类
 * @author: air
 * @create: 2019-12-19 14:48
 **/
public class CodeGenerator {
    private DataSourceProperties dataSourceProperties;
    private CodeGeneratorProperty codeGeneratorProperty;



    public void generator(DataSourceProperties dataSourceProperties, CodeGeneratorProperty codeGeneratorProperty) {
        this.codeGeneratorProperty = codeGeneratorProperty;
        this.dataSourceProperties = dataSourceProperties;

        // 生成实体类
        generatorStorage("vo");
        generatorStorage("entity");
        generatorStorage("dto");

        // 生成service
        generatorService("service");
        generatorService("domainService");


//
//        // 生成mapper
        generatorInfrastructure();
//
        generatorConvertor();
//
//        // 生成接口
        generatorControllerApi();
        generatorController();
//
//        // 生成config
//        generatorConfig("swagger");
        generatorConfig("cors");
//        generatorConfig("redisson");

        // 生成pom.xml
//        generatorPomXml("storages");
//        generatorPomXml("services");
//        generatorPomXml("infrastructure");
        // 改用复制文件的方式 2024年9月3日16:48:04
        try {

//            Files.write(Paths.get(codeGeneratorProperty.getOutputDir() +"storages/pom.xml"),
//                    createPom(codeGeneratorProperty.getGroupId(),
//                            codeGeneratorProperty.getArtifactId(),codeGeneratorProperty.getVersion(),"storages").getBytes());
//
//
//            ClassLoader classLoader = CodeGenerator.class.getClassLoader();
//            URL resource = classLoader.getResource("templates/air/pomStorages.xml");

            if (!Files.exists(Paths.get(codeGeneratorProperty.getOutputDir() +"storages/pom.xml"))){
                Files.write(Paths.get(codeGeneratorProperty.getOutputDir() +"storages/pom.xml"),
                        createPom(codeGeneratorProperty.getGroupId(),
                                codeGeneratorProperty.getArtifactId(),codeGeneratorProperty.getVersion(),"storages").getBytes());
//                Files.copy(classLoader.getResource("templates/air/pomStorages.xml").openStream(),Paths.get(codeGeneratorProperty.getOutputDir() +"storages/pom.xml"));
            }
            if (!Files.exists(Paths.get(codeGeneratorProperty.getOutputDir() +"services/pom.xml"))){
//                Files.copy(classLoader.getResource("templates/air/pomServices.xml").openStream(),Paths.get(codeGeneratorProperty.getOutputDir() +"services/pom.xml"));
                Files.write(Paths.get(codeGeneratorProperty.getOutputDir() +"services/pom.xml"),
                        createPom(codeGeneratorProperty.getGroupId(),
                                codeGeneratorProperty.getArtifactId(),codeGeneratorProperty.getVersion(),"services").getBytes());

            }
            if (!Files.exists(Paths.get(codeGeneratorProperty.getOutputDir() +"infrastructure/pom.xml"))){
//                Files.copy(classLoader.getResource("templates/air/pom.xml").openStream(),Paths.get(codeGeneratorProperty.getOutputDir() +"infrastructure/pom.xml"));
                Files.write(Paths.get(codeGeneratorProperty.getOutputDir() +"infrastructure/pom.xml"),
                        createPom(codeGeneratorProperty.getGroupId(),
                                codeGeneratorProperty.getArtifactId(),codeGeneratorProperty.getVersion(),"infrastructure").getBytes());
            }

        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * @param storageType vo,dto,entity
     */
    private void generatorStorage(String storageType) {
        System.out.println("------------fastAutoGeneratorCustom generatorStorage--------------");
        Map<String, Object> injectionConfigMap = injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create(dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword())
                .globalConfig(builder -> {
                    builder.author(codeGeneratorProperty.getAuthor()) // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .outputDir(codeGeneratorProperty.getOutputDir() + "storages/src/main/java"); // 指定输出目录
                })
                //注入配置
                .injectionConfig(injectionConfig -> {
                    injectionConfig.customMap(injectionConfigMap);
                })
                .packageConfig(builder -> {
                    builder.parent(codeGeneratorProperty.getParent() + ".storages") // 设置父包名
                            .entity(storageType)
                            .moduleName(codeGeneratorProperty.getModuleName()) // 设置父包模块名
                            .pathInfo(Collections.singletonMap(OutputFile.xml, codeGeneratorProperty.getOutputDir() + "/storages")); // 设置mapperXml生成路径
                })
//                .templateConfig(builder -> {
//                    if (storageType.equals("vo")) {
//                        builder.entity("/templates/air/vo.java")
//                                .disable(TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.SERVICE_IMPL, TemplateType.XML);
//                    }
//
//                    if (storageType.equals("dto")) {
//                        builder.entity("/templates/air/dto.java")
//                                .disable(TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.SERVICE_IMPL, TemplateType.XML);
//                    }
//                    if (storageType.equals("entity")) {
//                        builder.entity("/templates/air/entity.java")
//                                .disable(TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.SERVICE_IMPL, TemplateType.XML);
//                    }
//                })
                .strategyConfig(builder -> {
                    if (codeGeneratorProperty.getIncludeTables() != null) {
                        builder.addExclude(codeGeneratorProperty.getIncludeTables().split(",")); // 设置需要生成的表名
                    }
                    builder.addTablePrefix(codeGeneratorProperty.getTablePrefix()); // 设置过滤表前缀
                    builder.entityBuilder();
                    String suffix = null;
                    if (storageType.equals("vo")) {
                        suffix = "Vo";
                        builder.entityBuilder().javaTemplate("/templates/air/vo.java").naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel)
                                .enableLombok()
                                .idType(IdType.ASSIGN_ID).formatFileName("%s" + suffix);
                    }
                    if (storageType.equals("dto")) {
                        suffix = "Dto";
                        builder.entityBuilder().javaTemplate("/templates/air/dto.java").naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel)
                                .enableLombok()
                                .idType(IdType.ASSIGN_ID).formatFileName("%s" + suffix);
                    }
                    if (storageType.equals("entity")) {
                        suffix = "";
                        builder.entityBuilder().javaTemplate("/templates/air/entity.java").naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel)
                                .enableLombok()
                                .idType(IdType.ASSIGN_ID).formatFileName("%s" + suffix);
                    }
//                    builder.entityBuilder().naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel)
//                            .enableLombok()
//                            .idType(IdType.ASSIGN_ID).formatFileName("%s" + suffix);

                    if (storageType.equals("entity")) {
//                        builder.entityBuilder().enableTableFieldAnnotation();
                    }
                    builder.serviceBuilder().disable().controllerBuilder().disable().mapperBuilder().disable();


                })
                .templateEngine(new FreemarkerTemplateEngine());// 使用Freemarker引擎模板，默认的是Velocity引擎模板

        fastAutoGeneratorCustom.execute();
    }


    /**
     * @param serviceType service,domainService
     */
    private void generatorService(String serviceType) {
        System.out.println("------------fastAutoGeneratorCustom generatorService--------------");
        Map<String, Object> injectionConfigMap = injectionConfigMap();

        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create(dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword())
                .globalConfig(builder -> {
                    builder.author(codeGeneratorProperty.getAuthor()) // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .outputDir(codeGeneratorProperty.getOutputDir() + "services/src/main/java"); // 指定输出目录
                })
                //注入配置
                .injectionConfig(injectionConfig -> {
                    injectionConfig.customMap(injectionConfigMap);
                })
                .packageConfig(builder -> {
                    builder.parent(codeGeneratorProperty.getParent() + ".services") // 设置父包名
                            .service(serviceType)
                            .serviceImpl(serviceType + ".impl")
                            .moduleName(codeGeneratorProperty.getModuleName()) // 设置父包模块名
                            .pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp")); // 设置mapperXml生成路径
                })
//                .templateConfig(builder -> {
//                    if (serviceType.equals("domainService")) {
//                        builder.service("/templates/air/domainservice.java")
//                                .serviceImpl("/templates/air/domainserviceImpl.java")
//                                .disable(TemplateType.CONTROLLER, TemplateType.MAPPER, TemplateType.ENTITY);
//                    }
//
//                    if (serviceType.equals("service")) {
//                        builder.service("/templates/air/service.java")
//                                .serviceImpl("/templates/air/serviceImpl.java")
//                                .disable(TemplateType.CONTROLLER, TemplateType.MAPPER, TemplateType.ENTITY);
//                    }
//
//                })
                .strategyConfig(builder -> {
                    if (codeGeneratorProperty.getIncludeTables() != null) {
                        builder.addExclude(codeGeneratorProperty.getIncludeTables().split(",")); // 设置需要生成的表名
                    }
                    builder.addTablePrefix(codeGeneratorProperty.getTablePrefix()); // 设置过滤表前缀

                    if (serviceType.equals("domainService")) {
                        builder.serviceBuilder().serviceTemplate("/templates/air/domainservice.java")
                                .serviceImplTemplate("/templates/air/domainserviceImpl.java")
                                .formatServiceFileName("%sDomainService").formatServiceImplFileName("%sDomainServiceImpl");
                    }else {
                        builder.serviceBuilder().serviceTemplate("/templates/air/service.java")
                                .serviceImplTemplate("/templates/air/serviceImpl.java");
                    }

                    builder.entityBuilder().disable().controllerBuilder().disable().mapperBuilder().disable();
                })

                .templateEngine(new FreemarkerTemplateEngine());// 使用Freemarker引擎模板，默认的是Velocity引擎模板

        fastAutoGeneratorCustom.execute();
    }


    private void generatorController() {
        System.out.println("------------fastAutoGeneratorCustom generatorController--------------");
        Map<String, Object> injectionConfigMap = injectionConfigMap();

        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create(dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword())
                .globalConfig(builder -> {
                    builder.author(codeGeneratorProperty.getAuthor()) // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .outputDir(codeGeneratorProperty.getProjectPath() + "/src/main/java/"); // 指定输出目录
                })
                //注入配置
                .injectionConfig(injectionConfig -> {
                    injectionConfig.customMap(injectionConfigMap);
                })
                .packageConfig(builder -> {
                    builder.parent(codeGeneratorProperty.getParent()) // 设置父包名
                            .moduleName(codeGeneratorProperty.getModuleName()) // 设置父包模块名
                            .pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp")); // 设置mapperXml生成路径
                })
//                .templateConfig(builder -> {
//                    builder.controller("/templates/air/controller.java")
//                            .disable(TemplateType.SERVICE_IMPL, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.ENTITY, TemplateType.XML);
//
//                })
                .strategyConfig(builder -> {
                    if (codeGeneratorProperty.getIncludeTables() != null) {
                        builder.addExclude(codeGeneratorProperty.getIncludeTables().split(",")); // 设置需要生成的表名
                    }
                    builder.addTablePrefix(codeGeneratorProperty.getTablePrefix()); // 设置过滤表前缀
                    builder.controllerBuilder().template("/templates/air/controller.java");
                    builder.controllerBuilder().enableRestStyle();
                    builder.serviceBuilder().disable().mapperBuilder().disable().entityBuilder().disable();

                })
                .templateEngine(new FreemarkerTemplateEngine());// 使用Freemarker引擎模板，默认的是Velocity引擎模板

        fastAutoGeneratorCustom.execute();
    }


    private void generatorControllerApi() {
        System.out.println("------------fastAutoGeneratorCustom generatorControllerApi--------------");
        Map<String, Object> injectionConfigMap = injectionConfigMap();

        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create(dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword())
                .globalConfig(builder -> {
                    builder.author(codeGeneratorProperty.getAuthor()) // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .outputDir(codeGeneratorProperty.getProjectPath() + "/src/main/java/"); // 指定输出目录
                })
                //注入配置
                .injectionConfig(injectionConfig -> {
                    injectionConfig.customMap(injectionConfigMap);
                })
                .packageConfig(builder -> {
                    builder.parent(codeGeneratorProperty.getParent()) // 设置父包名
                            .controller("api")
                            .moduleName(codeGeneratorProperty.getModuleName()) // 设置父包模块名
                            .pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp")); // 设置mapperXml生成路径
                })
//                .templateConfig(builder -> {
//                    builder.controller("/templates/air/api.java")
//                            .disable(TemplateType.SERVICE_IMPL, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.ENTITY);
//
//                })
                .strategyConfig(builder -> {
                    if (codeGeneratorProperty.getIncludeTables() != null) {
                        builder.addExclude(codeGeneratorProperty.getIncludeTables().split(",")); // 设置需要生成的表名
                    }
                    builder.addTablePrefix(codeGeneratorProperty.getTablePrefix()); // 设置过滤表前缀
                    builder.controllerBuilder().template("/templates/air/api.java");
                    builder.controllerBuilder().formatFileName("%sApi");
                    builder.serviceBuilder().disable().mapperBuilder().disable().entityBuilder().disable();
                })
                .templateEngine(new FreemarkerTemplateEngine());// 使用Freemarker引擎模板，默认的是Velocity引擎模板

        fastAutoGeneratorCustom.execute();
    }

    private void generatorConvertor() {
        System.out.println("------------fastAutoGeneratorCustom generatorConvertor--------------");
        Map<String, Object> injectionConfigMap = injectionConfigMap();

        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create(dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword())
                .globalConfig(builder -> {
                    builder.author(codeGeneratorProperty.getAuthor()) // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .outputDir(codeGeneratorProperty.getOutputDir() + "storages/src/main/java"); // 指定输出目录
                })
                //注入配置
                .injectionConfig(injectionConfig -> {
                    injectionConfig.customMap(injectionConfigMap);
                })
                .packageConfig(builder -> {
                    builder.parent(codeGeneratorProperty.getParent() + ".storages") // 设置父包名
                            .controller("convertor")
                            .moduleName(codeGeneratorProperty.getModuleName()) // 设置父包模块名
                            .pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp")); // 设置mapperXml生成路径
                })
//                .templateConfig(builder -> {
//                    builder.controller("/templates/air/convertor.java")
//                            .disable(TemplateType.SERVICE_IMPL, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.ENTITY);
//
//                })
                .strategyConfig(builder -> {
                    if (codeGeneratorProperty.getIncludeTables() != null) {
                        builder.addExclude(codeGeneratorProperty.getIncludeTables().split(",")); // 设置需要生成的表名
                    }
                    builder.addTablePrefix(codeGeneratorProperty.getTablePrefix()); // 设置过滤表前缀
                    builder.controllerBuilder().template("/templates/air/convertor.java");
                    builder.controllerBuilder().formatFileName("%sConvertor");
                    builder.serviceBuilder().disable().entityBuilder().disable().mapperBuilder().disable();
                })
                .templateEngine(new FreemarkerTemplateEngine());// 使用Freemarker引擎模板，默认的是Velocity引擎模板

        fastAutoGeneratorCustom.execute();
    }

    private void generatorInfrastructure() {
        System.out.println("------------fastAutoGeneratorCustom generatorInfrastructure--------------");
        Map<String, Object> injectionConfigMap = injectionConfigMap();

        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create(dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword())
                .globalConfig(builder -> {
                    builder.author(codeGeneratorProperty.getAuthor()) // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .outputDir(codeGeneratorProperty.getOutputDir() + "infrastructure/src/main/java"); // 指定输出目录
                })
                //注入配置
                .injectionConfig(injectionConfig -> {
                    injectionConfig.customMap(injectionConfigMap);
                })
                .packageConfig(builder -> {
                    builder.parent(codeGeneratorProperty.getParent() + ".infrastructure") // 设置父包名
                            .moduleName(codeGeneratorProperty.getModuleName()) // 设置父包模块名
                            .pathInfo(Collections.singletonMap(OutputFile.xml, codeGeneratorProperty.getOutputDir() + "infrastructure/src/main/resources/mapper/" + codeGeneratorProperty.getModuleName())); // 设置mapperXml生成路径
                })
//                .templateConfig(builder -> {
//                    builder.mapper("/templates/air/mapper.java")
//                            .xml("/templates/air/mapper.xml")
//                            .disable(TemplateType.SERVICE_IMPL, TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.ENTITY);
//
//                })
                .strategyConfig(builder -> {
                    if (codeGeneratorProperty.getIncludeTables() != null) {
                        builder.addExclude(codeGeneratorProperty.getIncludeTables().split(",")); // 设置需要生成的表名
                    }
                    builder.mapperBuilder()
                            .mapperTemplate("/templates/air/mapper.java")
                            .mapperXmlTemplate("/templates/air/mapper.xml")
                            .entityBuilder().disable().controllerBuilder().disable().serviceBuilder().disable();
                    ;
                    builder.addTablePrefix(codeGeneratorProperty.getTablePrefix()); // 设置过滤表前缀
                })
                .templateEngine(new FreemarkerTemplateEngine());// 使用Freemarker引擎模板，默认的是Velocity引擎模板

        fastAutoGeneratorCustom.execute();
    }


    /**
     * @param modelName
     */
    private void generatorPomXml(String modelName) {
        System.out.println("------------fastAutoGeneratorCustom generatorPomXml--------------");
        Map<String, Object> injectionConfigMap = injectionConfigMap();
        injectionConfigMap.put("PomName", modelName);
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create(dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword())
                .globalConfig(builder -> {
                    builder.author(codeGeneratorProperty.getAuthor()) // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .outputDir(codeGeneratorProperty.getOutputDir() + modelName); // 指定输出目录
                })
                //注入配置
                .injectionConfig(injectionConfig -> {
                    injectionConfig.customMap(injectionConfigMap);
                })
                .packageConfig(builder -> {
                    builder.parent(codeGeneratorProperty.getParent()) // 设置父包名
                            .moduleName(codeGeneratorProperty.getModuleName()) // 设置父包模块名
                            .pathInfo(Collections.singletonMap(OutputFile.xml, codeGeneratorProperty.getOutputDir() + modelName)); // 设置mapperXml生成路径

                })
//                .templateConfig(builder -> {
//                    builder.xml("/templates/air/pom.xml")
//                            .disable(TemplateType.SERVICE_IMPL, TemplateType.CONTROLLER, TemplateType.SERVICE, TemplateType.ENTITY, TemplateType.MAPPER);
//
//                })

                .strategyConfig(builder -> {
                    builder.controllerBuilder().template("/templates/air/pom.xml");
                    builder.controllerBuilder().formatFileName("pom.xml");
                    builder.mapperBuilder().disable().serviceBuilder().disable().entityBuilder().disable();
                })
                .templateEngine(new FreemarkerTemplateEngine());// 使用Freemarker引擎模板，默认的是Velocity引擎模板

        fastAutoGeneratorCustom.execute();
    }


    /**
     * 生成配置文件
     * @param configType
     */
    private void generatorConfig(String configType) {
        System.out.println("------------fastAutoGeneratorCustom generatorConfig--------------");
        Map<String, Object> injectionConfigMap = injectionConfigMap();

        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create(dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword())
                .globalConfig(builder -> {
                    builder.author(codeGeneratorProperty.getAuthor()) // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .outputDir(codeGeneratorProperty.getProjectPath() + "/src/main/java/"); // 指定输出目录
                })
                //注入配置
                .injectionConfig(injectionConfig -> {
                    injectionConfig.customMap(injectionConfigMap);
                })
                .packageConfig(builder -> {
                    builder.parent(codeGeneratorProperty.getParent()) // 设置父包名
                            .controller("config")
                            .moduleName(codeGeneratorProperty.getModuleName()); // 设置父包模块名
                })
//                .templateConfig(builder -> {
//                    String template = "";
//                    if (configType.equals("swagger")) {
//                        template = "/templates/air/swagger3Config.java";
//                    }
//                    if (configType.equals("cors")) {
//                        template = "/templates/air/corsConfig.java";
//                    }
//                    if (configType.equals("redisson")) {
//                        template = "/templates/air/redissonConfig.java";
//                    }
//                    builder.controller(template)
//                            .disable(TemplateType.SERVICE_IMPL, TemplateType.SERVICE, TemplateType.MAPPER, TemplateType.ENTITY, TemplateType.XML);
//
//                })
                .strategyConfig(builder -> {
                    if (codeGeneratorProperty.getIncludeTables() != null) {
                        builder.addExclude(codeGeneratorProperty.getIncludeTables().split(",")); // 设置需要生成的表名
                    }
                    builder.addTablePrefix(codeGeneratorProperty.getTablePrefix()); // 设置过滤表前缀
                    if (configType.equals("swagger")) {
                        builder.controllerBuilder().template("/templates/air/swagger3Config.java");
                        builder.controllerBuilder().formatFileName("Swagger3Config");
                    }
                    if (configType.equals("cors")) {
                        builder.controllerBuilder().template("/templates/air/corsConfig.java");
                        builder.controllerBuilder().formatFileName("CORSConfig");
                    }
                    if (configType.equals("redisson")) {
                        builder.controllerBuilder().template("/templates/air/redissonConfig.java");
                        builder.controllerBuilder().formatFileName("RedissonConfig");
                    }
                    builder.serviceBuilder().disable().mapperBuilder().disable().entityBuilder().disable();
                })
                .templateEngine(new FreemarkerTemplateEngine());// 使用Freemarker引擎模板，默认的是Velocity引擎模板

        fastAutoGeneratorCustom.execute();
    }

    /**
     * 注入配置变量
     *
     * @return
     */
    private Map<String, Object> injectionConfigMap() {
        Map<String, Object> injectionConfigMap = new HashMap<>();
        String moduleNameName = codeGeneratorProperty.getModuleName();
        if (StringUtils.isNotEmpty(moduleNameName)) {
            moduleNameName = "." + moduleNameName;
        }

        injectionConfigMap.put("Api", codeGeneratorProperty.getParent() + moduleNameName + ".api");
        injectionConfigMap.put("Po", codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".po");
        injectionConfigMap.put("Vo", codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".vo");
        injectionConfigMap.put("Dto", codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".dto");
        injectionConfigMap.put("Entity", codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".entity");
        injectionConfigMap.put("Service", codeGeneratorProperty.getParent() + ".services" + moduleNameName + ".service");
        injectionConfigMap.put("DomainService", codeGeneratorProperty.getParent() + ".services" + moduleNameName + ".domainService");
        injectionConfigMap.put("ServiceImpl", codeGeneratorProperty.getParent() + ".services" + moduleNameName + ".service.impl");
        injectionConfigMap.put("DomainServiceImpl", codeGeneratorProperty.getParent() + ".services" + moduleNameName + ".domainService.impl");
        injectionConfigMap.put("Convertor", codeGeneratorProperty.getParent() + ".storages" + moduleNameName + ".convertor");
        injectionConfigMap.put("Config", codeGeneratorProperty.getParent() + moduleNameName + ".config");
        injectionConfigMap.put("Parent", codeGeneratorProperty.getParent());
        injectionConfigMap.put("Handler", codeGeneratorProperty.getParent() + moduleNameName + ".handler");
        injectionConfigMap.put("GroupId", codeGeneratorProperty.getGroupId());
        injectionConfigMap.put("Version", codeGeneratorProperty.getVersion());
        injectionConfigMap.put("ArtifactId", codeGeneratorProperty.getArtifactId());
        injectionConfigMap.put("Mapper", codeGeneratorProperty.getParent() + ".infrastructure" + moduleNameName + ".mapper");
        injectionConfigMap.put("PomName", null);
        injectionConfigMap.put("ApiPathPre", StringUtils.isEmpty(codeGeneratorProperty.getModuleName()) ? "" : codeGeneratorProperty.getModuleName() + "/");


        return injectionConfigMap;
    }


    private String createPom(String groupId, String artifactId, String version,String model){
        String s = """
                <?xml version="1.0" encoding="UTF-8"?>
                <project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd">
                    <modelVersion>4.0.0</modelVersion>
                    <parent>
                        <groupId>%s</groupId>
                        <artifactId>%s</artifactId>
                        <version>%s</version>
                    </parent>
                    <artifactId>storages</artifactId>
                    <version>1.0</version>
                    <name>storages</name>
                    <description>Demo project for Spring Boot</description>
                                
                    <properties>
                        <java.version>17</java.version>
                    </properties>
                                
                    <dependencies>
                                
                                
                    </dependencies>
                                
                </project>
                                
                """.formatted(groupId,artifactId,version);

        if (model.equals("services")){
            s = """
                <?xml version="1.0" encoding="UTF-8"?>
                <project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd">
                    <modelVersion>4.0.0</modelVersion>
                    <parent>
                        <groupId>%s</groupId>
                        <artifactId>%s</artifactId>
                        <version>%s</version>
                    </parent>
                    <artifactId>services</artifactId>
                    <version>1.0</version>
                    <name>services</name>
                    <description>Demo project for Spring Boot</description>
                                
                    <properties>
                        <java.version>17</java.version>
                    </properties>
                                
                    <dependencies>
                       <dependency>
                           <groupId>%s</groupId>
                           <artifactId>storages</artifactId>
                           <version>1.0</version>
                       </dependency>
                        <dependency>
                            <groupId>%s</groupId>
                            <artifactId>infrastructure</artifactId>
                            <version>1.0</version>
                        </dependency>  
                                
                    </dependencies>
                                
                </project>
                                
                """.formatted(groupId,artifactId,version,groupId,groupId);
        }

        if (model.equals("infrastructure")){
            s = """
                <?xml version="1.0" encoding="UTF-8"?>
                <project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd">
                    <modelVersion>4.0.0</modelVersion>
                    <parent>
                        <groupId>%s</groupId>
                        <artifactId>%s</artifactId>
                        <version>%s</version>
                    </parent>
                    <artifactId>infrastructure</artifactId>
                    <version>1.0</version>
                    <name>infrastructure</name>
                    <description>Demo project for Spring Boot</description>
                                
                    <properties>
                        <java.version>17</java.version>
                    </properties>
                                
                    <dependencies>
                       <dependency>
                           <groupId>%s</groupId>
                           <artifactId>storages</artifactId>
                           <version>1.0</version>
                       </dependency>
  
                    </dependencies>
                                
                </project>
                                
                """.formatted(groupId,artifactId,version,groupId);
        }

        return s;
    }
}
