package cn.airfei.aircore.core.common;


import cn.airfei.aircore.core.enums.RespEnum;
import cn.airfei.aircore.core.exception.AppException;
import cn.airfei.aircore.core.extend.ParseHeaderAuthorization;
import cn.airfei.aircore.core.properties.AirCoreProperty;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import jakarta.annotation.Resource;


/**
 * 统一抛出异常
 *
 * @author air
 * @create 2019年05月30日15:59:31
 */
@RestControllerAdvice
@Slf4j
@Component
@Hidden
public class Error implements ErrorController {
    @Resource
    private AirCoreProperty airCoreProperty;
    @Resource
    private ParseHeaderAuthorization parseHeaderAuthorization;

    /**
     * 拦截控制器请求错误信息
     *
     * @param req req
     * @param e   exception
     * @return resp
     * @throws Exception
     */
    @ExceptionHandler(value = Exception.class)
    public Resp defaultErrorHandler(HttpServletRequest req, Exception e, HttpServletResponse response) throws Exception {
        log.error("path:{},errorMsg:{}", req.getContextPath() + req.getServletPath() + "?" + req.getQueryString(), e.getMessage());
        return Resp.response(RespEnum.SYSTEM_ERROR.getCode(), RespEnum.SYSTEM_ERROR.getMsg() + e.getMessage(), String.valueOf(req.getAttribute("traceId")));
    }


    /**
     * 自定义异常拦截 （AppException）
     *
     * @param req
     * @param e
     * @return
     */
    @ExceptionHandler(AppException.class)
    public Resp appExceptionHandler(HttpServletRequest req, AppException e) {
        log.error("path:{},errorMsg:{}", req.getContextPath() + req.getServletPath() + "?" + req.getQueryString(), e.getMessage());
        return Resp.response(e.getCode(), e.getMsg(), String.valueOf(req.getAttribute("traceId")));
    }

}
