package ${package.Controller}.rest;

import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;
import ${cfg.ServiceImpl}.${entity}ServiceImpl;
import ${cfg.Dto}.${entity}Dto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import cn.airfei.aircore.core.common.Resp;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import jakarta.annotation.Resource;
import springfox.documentation.annotations.ApiIgnore;
<#if restControllerStyle>
import org.springframework.web.bind.annotation.RestController;
<#else>
import org.springframework.stereotype.Controller;
</#if>
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>


/**
 * <p>
 * ${table.comment!}
 * </p>
 *
 * @author ${author}
 * @version v1.0
 * @since ${date}
 */
<#if restControllerStyle>
@Api(value = "${table.comment!}",tags = {"${entity} ${table.comment!}"})
@RestController
@Slf4j
<#else>
@Controller
</#if>
@RequestMapping("<#if package.ModuleName??>/${package.ModuleName}</#if>/<#if controllerMappingHyphenStyle??>${controllerMappingHyphen}<#else>${table.entityPath}</#if>")
<#if kotlin>
class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
<#if superControllerClass??>
public class ${entity}Rest extends ${superControllerClass} {
<#else>
public class ${entity}Rest {
</#if>
    @Resource
    private ${entity}ServiceImpl ${entity?uncap_first}Service;


    /**
     * display a listing of the resource.
     *
     * @param pageNum
     * @param pageSize
     * @return
     */
    @ApiOperation(value = "display a listing of the resource.")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = ${entity}Dto.class)})
    @GetMapping(value = "/")
    public Resp index(@RequestParam(name = "pageNum", defaultValue = "1") int pageNum, @RequestParam(name = "pageSize", defaultValue = "20") int pageSize){
        return null;
    }



    /**
     * 只查询单表数据，不关联任何表
     *
     * @param map
     * @return
     */
    @ApiOperation(value = "查询${table.comment!}列表,只查询单表数据，不关联任何表," +
            "列表(qp-参数支持的操作符号有: eq(=),ne(!=),gt(>),lt(<),ge(>=),le(<=),in,like,notLike,likeleft(左边LIKE '%xxx'),likeright(右边LIKE 'xx%'))")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = ${entity}Dto.class)})
    @GetMapping(value = "singleTablePage")
    @ApiImplicitParams({
    <#list table.fields as field>
            @ApiImplicitParam(name = "qp-${field.propertyName}-eq",value = "${field.comment}" ,paramType = "query"),
    </#list>
            @ApiImplicitParam(name = "page-current",value = "当前页" ,paramType = "query" , dataType = "long",defaultValue = "1"),
            @ApiImplicitParam(name = "page-size",value = "分页大小" ,paramType = "query" , dataType = "long",defaultValue = "15")
    })
    public Resp singleTablePage(@ApiIgnore @RequestParam Map<String,Object> map){
        return Resp.response(${entity?uncap_first}Service.singleTablePage(map));
    }


    /**
     * Display the specified resource.
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "Display the specified resource.")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败")})
    @GetMapping(value = "/{id}")
    public Resp show(@PathVariable("id") String id) {
        return Resp.response(${entity?uncap_first}Service.show(id));
    }


    /**
    * Store a newly created resource in storage.
    *
    * @param ${entity?uncap_first}Dto
    * @return
    */
    @ApiOperation(value = "Store a newly created resource in storage.")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = ${entity}Dto.class)})
    @PostMapping(value = "")
    public Resp store(@RequestBody ${entity}Dto ${entity?uncap_first}Dto) {
        return Resp.response(${entity?uncap_first}Service.store(${entity?uncap_first}Dto));
    }


    /**
    * Remove the specified resource from storage.
    *
    * @param ids
    * @return
    */
    @ApiOperation(value = "Remove the specified resource from storage.")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败")})
    @DeleteMapping(value = "/{ids}")
    public Resp destroy(@PathVariable("ids") String ids) {
        return Resp.response(${entity?uncap_first}Service.destroy(ids));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param ${entity?uncap_first}Dto
     * @return
     */
    @ApiOperation(value = "Update the specified resource in storage.")
    @ApiResponses(value = {@ApiResponse(code = 0, message = "0:成功，否则失败",response = ${entity}Dto.class)})
    @PutMapping(value = "")
    public Resp update(@RequestBody ${entity}Dto ${entity?uncap_first}Dto) {
        return Resp.response(${entity?uncap_first}Service.update(${entity?uncap_first}Dto));
    }

}
</#if>
