package ${cfg.Handler};

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * mybatis plus 自动更新数据
 *
 * @author ${author}
 * @since ${date}
 */
@Component
public class MyMetaObjectHandler implements MetaObjectHandler {
    Boolean deletedDefault = false;

    @Override
    public void insertFill(MetaObject metaObject) {
        this.setFieldValByName("createTime", new Date(), metaObject);
        this.setFieldValByName("updateTime", new Date(), metaObject);
        this.setFieldValByName("EXCHANGE_DATE", new Date(), metaObject);
        this.setFieldValByName("UPDATED_DATE", new Date(), metaObject);
        this.setFieldValByName("CREATED_DATE", new Date(), metaObject);
        this.setFieldValByName("createdAt", new Date(), metaObject);
        this.setFieldValByName("updatedAt", new Date(), metaObject);


        Object deleted = getFieldValByName("deleted", metaObject);
        if (deleted == null) {
            setFieldValByName("deleted", deletedDefault, metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        this.setFieldValByName("updateTime", new Date(), metaObject);
        this.setFieldValByName("UPDATED_DATE", new Date(), metaObject);
        this.setFieldValByName("updatedAt", new Date(), metaObject);
    }
}
