/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.utils;

import jakarta.annotation.Resource;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public boolean setIfAbsent(String key, String value) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public boolean setIfAbsent(String key, String value, Long seconds) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, Duration.ofSeconds(seconds));
    }

    public boolean setIfAbsent(String key, String value, Long time, TimeUnit timeUnit) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, time.longValue(), timeUnit);
    }

    public void set(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public void set(String key, String value, Duration duration) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, duration);
    }

    public void set(String key, String value, Long duration) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, Duration.ofSeconds(duration));
    }

    public void set(String key, String value, Long timeOut, TimeUnit utils) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeOut.longValue(), utils);
    }

    public boolean expire(String key, Long timeOut, TimeUnit units) {
        return this.stringRedisTemplate.expire((Object)key, timeOut.longValue(), units);
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public boolean remove(String key) {
        return this.stringRedisTemplate.opsForValue().getOperations().delete((Object)key);
    }

    public boolean delete(String key) {
        return this.stringRedisTemplate.delete((Object)key);
    }

    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }
}

