/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.generator;

import cn.airfei.aircore.core.properties.CodeGeneratorProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class CodeGenerator {
    private DataSourceProperties dataSourceProperties;
    private CodeGeneratorProperty codeGeneratorProperty;

    public void generator(DataSourceProperties dataSourceProperties, CodeGeneratorProperty codeGeneratorProperty) {
        this.codeGeneratorProperty = codeGeneratorProperty;
        this.dataSourceProperties = dataSourceProperties;
        this.generatorStorage("vo");
        this.generatorStorage("entity");
        this.generatorStorage("dto");
        this.generatorService("service");
        this.generatorService("domainService");
        this.generatorInfrastructure();
        this.generatorConvertor();
        this.generatorControllerApi();
        this.generatorController();
        this.generatorConfig("cors");
        try {
            if (!Files.exists(Paths.get(codeGeneratorProperty.getOutputDir() + "storages/pom.xml", new String[0]), new LinkOption[0])) {
                Files.write(Paths.get(codeGeneratorProperty.getOutputDir() + "storages/pom.xml", new String[0]), this.createPom(codeGeneratorProperty.getGroupId(), codeGeneratorProperty.getArtifactId(), codeGeneratorProperty.getVersion(), "storages").getBytes(), new OpenOption[0]);
            }
            if (!Files.exists(Paths.get(codeGeneratorProperty.getOutputDir() + "services/pom.xml", new String[0]), new LinkOption[0])) {
                Files.write(Paths.get(codeGeneratorProperty.getOutputDir() + "services/pom.xml", new String[0]), this.createPom(codeGeneratorProperty.getGroupId(), codeGeneratorProperty.getArtifactId(), codeGeneratorProperty.getVersion(), "services").getBytes(), new OpenOption[0]);
            }
            if (!Files.exists(Paths.get(codeGeneratorProperty.getOutputDir() + "infrastructure/pom.xml", new String[0]), new LinkOption[0])) {
                Files.write(Paths.get(codeGeneratorProperty.getOutputDir() + "infrastructure/pom.xml", new String[0]), this.createPom(codeGeneratorProperty.getGroupId(), codeGeneratorProperty.getArtifactId(), codeGeneratorProperty.getVersion(), "infrastructure").getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generatorStorage(String storageType) {
        System.out.println("------------fastAutoGeneratorCustom generatorStorage--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + "storages/src/main/java")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent() + ".storages").entity(storageType).moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, this.codeGeneratorProperty.getOutputDir() + "/storages"))).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            builder.entityBuilder();
            String suffix = null;
            if (storageType.equals("vo")) {
                suffix = "Vo";
                builder.entityBuilder().javaTemplate("/templates/air/vo.java").naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel).enableLombok().idType(IdType.ASSIGN_ID).formatFileName("%s" + suffix);
            }
            if (storageType.equals("dto")) {
                suffix = "Dto";
                builder.entityBuilder().javaTemplate("/templates/air/dto.java").naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel).enableLombok().idType(IdType.ASSIGN_ID).formatFileName("%s" + suffix);
            }
            if (storageType.equals("entity")) {
                suffix = "";
                builder.entityBuilder().javaTemplate("/templates/air/entity.java").naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel).enableLombok().idType(IdType.ASSIGN_ID).formatFileName("%s" + suffix);
            }
            if (storageType.equals("entity")) {
                // empty if block
            }
            builder.serviceBuilder().disable().controllerBuilder().disable().mapperBuilder().disable();
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorService(String serviceType) {
        System.out.println("------------fastAutoGeneratorCustom generatorService--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + "services/src/main/java")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent() + ".services").service(serviceType).serviceImpl(serviceType + ".impl").moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp"))).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            if (serviceType.equals("domainService")) {
                builder.serviceBuilder().serviceTemplate("/templates/air/domainservice.java").serviceImplTemplate("/templates/air/domainserviceImpl.java").formatServiceFileName("%sDomainService").formatServiceImplFileName("%sDomainServiceImpl");
            } else {
                builder.serviceBuilder().serviceTemplate("/templates/air/service.java").serviceImplTemplate("/templates/air/serviceImpl.java");
            }
            builder.entityBuilder().disable().controllerBuilder().disable().mapperBuilder().disable();
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorController() {
        System.out.println("------------fastAutoGeneratorCustom generatorController--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getProjectPath() + "/src/main/java/")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent()).moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp"))).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            builder.controllerBuilder().template("/templates/air/controller.java");
            builder.controllerBuilder().enableRestStyle();
            builder.serviceBuilder().disable().mapperBuilder().disable().entityBuilder().disable();
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorControllerApi() {
        System.out.println("------------fastAutoGeneratorCustom generatorControllerApi--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getProjectPath() + "/src/main/java/")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent()).controller("api").moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp"))).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            builder.controllerBuilder().template("/templates/air/api.java");
            builder.controllerBuilder().formatFileName("%sApi");
            builder.serviceBuilder().disable().mapperBuilder().disable().entityBuilder().disable();
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorConvertor() {
        System.out.println("------------fastAutoGeneratorCustom generatorConvertor--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + "storages/src/main/java")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent() + ".storages").controller("convertor").moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, "/tmp"))).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            builder.controllerBuilder().template("/templates/air/convertor.java");
            builder.controllerBuilder().formatFileName("%sConvertor");
            builder.serviceBuilder().disable().entityBuilder().disable().mapperBuilder().disable();
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorInfrastructure() {
        System.out.println("------------fastAutoGeneratorCustom generatorInfrastructure--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + "infrastructure/src/main/java")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent() + ".infrastructure").moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, this.codeGeneratorProperty.getOutputDir() + "infrastructure/src/main/resources/mapper/" + this.codeGeneratorProperty.getModuleName()))).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.mapperBuilder().mapperTemplate("/templates/air/mapper.java").mapperXmlTemplate("/templates/air/mapper.xml").entityBuilder().disable().controllerBuilder().disable().serviceBuilder().disable();
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorPomXml(String modelName) {
        System.out.println("------------fastAutoGeneratorCustom generatorPomXml--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        injectionConfigMap.put("PomName", modelName);
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getOutputDir() + modelName)).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent()).moduleName(this.codeGeneratorProperty.getModuleName()).pathInfo(Collections.singletonMap(OutputFile.xml, this.codeGeneratorProperty.getOutputDir() + modelName))).strategyConfig(builder -> {
            builder.controllerBuilder().template("/templates/air/pom.xml");
            builder.controllerBuilder().formatFileName("pom.xml");
            builder.mapperBuilder().disable().serviceBuilder().disable().entityBuilder().disable();
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private void generatorConfig(String configType) {
        System.out.println("------------fastAutoGeneratorCustom generatorConfig--------------");
        Map<String, Object> injectionConfigMap = this.injectionConfigMap();
        FastAutoGenerator fastAutoGeneratorCustom = FastAutoGenerator.create((String)this.dataSourceProperties.getUrl(), (String)this.dataSourceProperties.getUsername(), (String)this.dataSourceProperties.getPassword()).globalConfig(builder -> builder.author(this.codeGeneratorProperty.getAuthor()).enableSwagger().outputDir(this.codeGeneratorProperty.getProjectPath() + "/src/main/java/")).injectionConfig(injectionConfig -> injectionConfig.customMap(injectionConfigMap)).packageConfig(builder -> builder.parent(this.codeGeneratorProperty.getParent()).controller("config").moduleName(this.codeGeneratorProperty.getModuleName())).strategyConfig(builder -> {
            if (this.codeGeneratorProperty.getIncludeTables() != null) {
                builder.addExclude(this.codeGeneratorProperty.getIncludeTables().split(","));
            }
            builder.addTablePrefix(new String[]{this.codeGeneratorProperty.getTablePrefix()});
            if (configType.equals("swagger")) {
                builder.controllerBuilder().template("/templates/air/swagger3Config.java");
                builder.controllerBuilder().formatFileName("Swagger3Config");
            }
            if (configType.equals("cors")) {
                builder.controllerBuilder().template("/templates/air/corsConfig.java");
                builder.controllerBuilder().formatFileName("CORSConfig");
            }
            if (configType.equals("redisson")) {
                builder.controllerBuilder().template("/templates/air/redissonConfig.java");
                builder.controllerBuilder().formatFileName("RedissonConfig");
            }
            builder.serviceBuilder().disable().mapperBuilder().disable().entityBuilder().disable();
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        fastAutoGeneratorCustom.execute();
    }

    private Map<String, Object> injectionConfigMap() {
        HashMap<String, Object> injectionConfigMap = new HashMap<String, Object>();
        Object moduleNameName = this.codeGeneratorProperty.getModuleName();
        if (StringUtils.isNotEmpty((CharSequence)moduleNameName)) {
            moduleNameName = "." + (String)moduleNameName;
        }
        injectionConfigMap.put("Api", this.codeGeneratorProperty.getParent() + (String)moduleNameName + ".api");
        injectionConfigMap.put("Po", this.codeGeneratorProperty.getParent() + ".storages" + (String)moduleNameName + ".po");
        injectionConfigMap.put("Vo", this.codeGeneratorProperty.getParent() + ".storages" + (String)moduleNameName + ".vo");
        injectionConfigMap.put("Dto", this.codeGeneratorProperty.getParent() + ".storages" + (String)moduleNameName + ".dto");
        injectionConfigMap.put("Entity", this.codeGeneratorProperty.getParent() + ".storages" + (String)moduleNameName + ".entity");
        injectionConfigMap.put("Service", this.codeGeneratorProperty.getParent() + ".services" + (String)moduleNameName + ".service");
        injectionConfigMap.put("DomainService", this.codeGeneratorProperty.getParent() + ".services" + (String)moduleNameName + ".domainService");
        injectionConfigMap.put("ServiceImpl", this.codeGeneratorProperty.getParent() + ".services" + (String)moduleNameName + ".service.impl");
        injectionConfigMap.put("DomainServiceImpl", this.codeGeneratorProperty.getParent() + ".services" + (String)moduleNameName + ".domainService.impl");
        injectionConfigMap.put("Convertor", this.codeGeneratorProperty.getParent() + ".storages" + (String)moduleNameName + ".convertor");
        injectionConfigMap.put("Config", this.codeGeneratorProperty.getParent() + (String)moduleNameName + ".config");
        injectionConfigMap.put("Parent", this.codeGeneratorProperty.getParent());
        injectionConfigMap.put("Handler", this.codeGeneratorProperty.getParent() + (String)moduleNameName + ".handler");
        injectionConfigMap.put("GroupId", this.codeGeneratorProperty.getGroupId());
        injectionConfigMap.put("Version", this.codeGeneratorProperty.getVersion());
        injectionConfigMap.put("ArtifactId", this.codeGeneratorProperty.getArtifactId());
        injectionConfigMap.put("Mapper", this.codeGeneratorProperty.getParent() + ".infrastructure" + (String)moduleNameName + ".mapper");
        injectionConfigMap.put("PomName", null);
        injectionConfigMap.put("ApiPathPre", StringUtils.isEmpty((CharSequence)this.codeGeneratorProperty.getModuleName()) ? "" : this.codeGeneratorProperty.getModuleName() + "/");
        return injectionConfigMap;
    }

    private String createPom(String groupId, String artifactId, String version, String model) {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <parent>\n        <groupId>%s</groupId>\n        <artifactId>%s</artifactId>\n        <version>%s</version>\n    </parent>\n    <artifactId>storages</artifactId>\n    <version>1.0</version>\n    <name>storages</name>\n    <description>Demo project for Spring Boot</description>\n\n    <properties>\n        <java.version>17</java.version>\n    </properties>\n\n    <dependencies>\n\n\n    </dependencies>\n\n</project>\n\n".formatted(groupId, artifactId, version);
        if (model.equals("services")) {
            s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <parent>\n        <groupId>%s</groupId>\n        <artifactId>%s</artifactId>\n        <version>%s</version>\n    </parent>\n    <artifactId>services</artifactId>\n    <version>1.0</version>\n    <name>services</name>\n    <description>Demo project for Spring Boot</description>\n\n    <properties>\n        <java.version>17</java.version>\n    </properties>\n\n    <dependencies>\n       <dependency>\n           <groupId>%s</groupId>\n           <artifactId>storages</artifactId>\n           <version>1.0</version>\n       </dependency>\n        <dependency>\n            <groupId>%s</groupId>\n            <artifactId>infrastructure</artifactId>\n            <version>1.0</version>\n        </dependency>\n\n    </dependencies>\n\n</project>\n\n".formatted(groupId, artifactId, version, groupId, groupId);
        }
        if (model.equals("infrastructure")) {
            s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <parent>\n        <groupId>%s</groupId>\n        <artifactId>%s</artifactId>\n        <version>%s</version>\n    </parent>\n    <artifactId>infrastructure</artifactId>\n    <version>1.0</version>\n    <name>infrastructure</name>\n    <description>Demo project for Spring Boot</description>\n\n    <properties>\n        <java.version>17</java.version>\n    </properties>\n\n    <dependencies>\n       <dependency>\n           <groupId>%s</groupId>\n           <artifactId>storages</artifactId>\n           <version>1.0</version>\n       </dependency>\n\n    </dependencies>\n\n</project>\n\n".formatted(groupId, artifactId, version, groupId);
        }
        return s;
    }
}

