/*
 * Decompiled with CFR 0.152.
 */
package cn.airfei.aircore.core.aspect;

import cn.airfei.aircore.core.annotations.RedissonLock;
import cn.airfei.aircore.core.exception.AppException;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedissonLockAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedissonLockAspect.class);
    private static final ThreadLocal<String> keyMd5Context = new ThreadLocal();
    private static final Integer CODE = 722001;
    private static final String ERROR_MSG = "\u60a8\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41,\u7cfb\u7edf\u5fd9\u4e0d\u8fc7\u6765\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5\u8bd5";
    @Resource
    private HttpServletRequest httpServletRequest;
    @Resource
    private RedissonClient redissonClient;

    @Pointcut(value="@annotation(cn.airfei.aircore.core.annotations.RedissonLock)")
    public void annotationPointcut() {
    }

    @Before(value="annotationPointcut()")
    public void before(JoinPoint jp) {
        block6: {
            String keyMd5 = this.setRedisKeyMd5(jp);
            RLock lock = this.redissonClient.getLock(keyMd5);
            try {
                boolean tryLock = lock.tryLock(120L, 60L, TimeUnit.SECONDS);
                if (tryLock) break block6;
                if (this.httpServletRequest != null) {
                    try {
                        log.warn("\u6210\u529f\u62e6\u622a\u91cd\u590d\u8bf7\u6c42,url:{},method:{},ip:{}", new Object[]{this.httpServletRequest.getRequestURI(), this.httpServletRequest.getMethod(), this.httpServletRequest.getRemoteAddr()});
                    }
                    catch (Exception e) {
                        log.warn("\u975ehttp\u8bf7\u6c42,keyMd5:{},\u7ebf\u7a0b\uff1a{},\u7ebf\u7a0bid\uff1a{}", new Object[]{keyMd5, Thread.currentThread(), Thread.currentThread().getId()});
                    }
                }
                throw new AppException(CODE, ERROR_MSG);
            }
            catch (InterruptedException e) {
                log.error("tryLock \u53d1\u751f\u5f02\u5e38\u4e86,{}", (Object)e.getMessage());
                if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
                throw new AppException(CODE, e.getMessage());
            }
        }
    }

    @AfterReturning(value="annotationPointcut()", returning="result")
    public void afterReturning(JoinPoint jp, Object result) {
        String keyMd5 = keyMd5Context.get();
        RLock lock = this.redissonClient.getLock(keyMd5);
        if (lock.isLocked() && lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    @AfterThrowing(value="annotationPointcut()", throwing="e")
    public void afterThrowing(JoinPoint jp, Exception e) {
        String keyMd5 = keyMd5Context.get();
        RLock lock = this.redissonClient.getLock(keyMd5);
        if (lock.isLocked() && lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    private String setRedisKeyMd5(JoinPoint jp) {
        String[] lockFieldArr;
        RedissonLock redissonLock = ((MethodSignature)jp.getSignature()).getMethod().getAnnotation(RedissonLock.class);
        if (!redissonLock.lockKey().equals("")) {
            log.info("lockKey :{}", (Object)redissonLock.lockKey());
            keyMd5Context.set(redissonLock.lockKey());
            return redissonLock.lockKey();
        }
        StringBuilder lockName = new StringBuilder();
        if (this.httpServletRequest != null) {
            try {
                lockName.append(this.httpServletRequest.getMethod());
                lockName.append(this.httpServletRequest.getRequestURL());
            }
            catch (Exception e) {
                log.warn("\u975ehttp\u8bf7\u6c42,\u7ebf\u7a0b\uff1a{},\u7ebf\u7a0bid\uff1a{}", (Object)Thread.currentThread(), (Object)Thread.currentThread().getId());
            }
        }
        Object[] objects = jp.getArgs();
        String[] stringArray = lockFieldArr = StringUtils.isNotEmpty((CharSequence)redissonLock.lockFields()) ? redissonLock.lockFields().split(",") : new String[]{};
        if (lockFieldArr.length == 0) {
            lockName.append(Arrays.toString(objects));
        }
        block4: for (String lockField : lockFieldArr) {
            for (Object o : objects) {
                Field[] declaredFields;
                boolean mark = false;
                Class<?> aClass = o.getClass();
                for (Field field : declaredFields = aClass.getDeclaredFields()) {
                    if (!field.getName().equals(lockField)) continue;
                    try {
                        field.setAccessible(true);
                        Object o1 = field.get(o);
                        lockName.append(o1);
                        mark = true;
                        break;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (mark) continue block4;
            }
        }
        String md5Hex = DigestUtils.md5Hex((String)lockName.toString());
        log.info("lockName md5\u7f16\u7801\u524d:{}", (Object)lockName.toString());
        keyMd5Context.set(md5Hex);
        return md5Hex;
    }
}

