package cn.airfei.aircore.core.storage;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: air
 * @create: 2020-01-02 09:55
 **/
@Data
@Schema(name = "分页参数", description = "分页参数")
public class PageParam implements Serializable {
    @Schema(description = "当前页")
    private Long pageCurrent = 1L;

    @Schema(description = "分页大小")
    private Long pageSize = 15L;

    @Schema(description = "分页大小")
    private Integer total;

    @Schema(description = "存储时间字符串")
    private String date;

    @Schema(description = "开始时间")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    private LocalDateTime startTime;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    @Schema(description = "结束时间")
    private LocalDateTime endTime;
}
